/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CheckGreedy
extends TestRepo {
    private InputStream inputStream;

    public CheckGreedy(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public boolean testGreedyOptionals() throws ParserConfigurationException, SAXException, IOException {
        Document document = this.getDocument();
        return this.checkOptionals(document);
    }

    private Document getDocument() throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Reader characterStream = this.getCharacterStream();
        if (characterStream != null) {
            InputSource is = new InputSource(characterStream);
            document = documentBuilder.parse(is);
        }
        return document;
    }

    private Reader getCharacterStream() throws IOException {
        Reader characterStream = null;
        characterStream = Boolean.FALSE != false ? this.getCharacterStreamFromFile() : this.getCharacterStreamFromURL();
        return characterStream;
    }

    private Reader getCharacterStreamFromURL() throws IOException {
        InputStreamReader characterStream = null;
        URL url = null;
        InputStream rawinputStream = null;
        this.inputStream = null;
        URLConnection connection = null;
        System.out.println("repoURLToTest: " + this.getRepoURLToTest());
        url = new URL(String.valueOf(this.getRepoURLToTest()) + "/" + "content.jar");
        try {
            connection = url.openConnection();
            rawinputStream = connection.getInputStream();
            ZipInputStream zipStream = new ZipInputStream(rawinputStream);
            ZipEntry zipEntry = zipStream.getNextEntry();
            String entryName = null;
            while ((entryName = zipEntry.getName()) != null && !entryName.equals("content.xml") && (zipEntry = zipStream.getNextEntry()) != null) {
            }
            if (entryName != null && !entryName.equals("content.xml")) {
                throw new IllegalArgumentException("zip entry 'content.xml' was not found as expected.");
            }
            System.out.println("Found: " + this.getRepoURLToTest() + "/" + "content.jar");
            String localFilePathName = this.createLocalFile(zipStream, zipEntry);
            File file = new File(localFilePathName);
            System.out.println("Created. converted, and using local file: " + file.getAbsolutePath());
            this.inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            url = new URL(String.valueOf(this.getRepoURLToTest()) + "/" + "content.xml");
            try {
                connection = url.openConnection();
                this.inputStream = connection.getInputStream();
            }
            catch (FileNotFoundException e1) {
                throw new IllegalArgumentException("Neither content.jar nor content.xml file found at URL: " + this.getRepoURLToTest());
            }
        }
        if (this.inputStream != null) {
            characterStream = new InputStreamReader(this.inputStream);
        }
        return characterStream;
    }

    private String createLocalFile(ZipInputStream zipStream, ZipEntry zipEntry) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[8192];
        String outpath = String.valueOf(this.getConfigurations().getTempWorkingDir()) + "/" + zipEntry.getName();
        try (FileOutputStream output = null;){
            output = new FileOutputStream(outpath);
            int len = 0;
            while ((len = zipStream.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
        return outpath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Reader getCharacterStreamFromFile() {
        InputStreamReader characterStream = null;
        File file = new File(String.valueOf(this.getDirectoryToCheck()) + "/" + "content.jar");
        if (file.exists()) {
            ZipFile zipfile = null;
            try {
                try {
                    zipfile = new ZipFile(file);
                    ZipEntry zipEntry = zipfile.getEntry("content.xml");
                    InputStream inputStream = zipfile.getInputStream(zipEntry);
                    characterStream = new InputStreamReader(inputStream);
                    System.out.println("Using content.jar file from " + this.getDirectoryToCheck());
                    return characterStream;
                }
                catch (ZipException e) {
                    e.printStackTrace();
                    if (zipfile == null) return characterStream;
                    try {
                        zipfile.close();
                        return characterStream;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return characterStream;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zipfile == null) return characterStream;
                    try {
                        zipfile.close();
                        return characterStream;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    return characterStream;
                }
            }
            finally {
                if (zipfile != null) {
                    try {
                        zipfile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        file = new File(String.valueOf(this.getRepoURLToTest()) + "/" + "content.xml");
        if (!file.exists()) {
            throw new RuntimeException("neither content.jar nor content.xml file found at " + this.getDirectoryToCheck());
        }
        try {
            characterStream = new FileReader(file);
            System.out.println("Using content.xml file from " + this.getDirectoryToCheck());
            return characterStream;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Program Error, for file suddenly disappeared after being found.", e);
        }
    }

    protected boolean xcheckGreedyOptionals(Document document) throws IOException {
        NodeList iuElements = document.getElementsByTagName("unit");
        int nUnits = iuElements.getLength();
        int i = 0;
        while (i < nUnits) {
            Node iuNode = iuElements.item(i);
            String idString = this.getAttributeValue(iuNode, "id");
            System.out.println("id: " + idString);
            ++i;
        }
        this.checkOptionals(document);
        return false;
    }

    private String getAttributeValue(Node node, String attribute) {
        NamedNodeMap attributes;
        Node id;
        String result = null;
        if (node != null && (id = (attributes = node.getAttributes()).getNamedItem(attribute)) != null) {
            result = id.getNodeValue();
        }
        return result;
    }

    private boolean checkOptionals(Document document) throws IOException {
        boolean result = false;
        if (document == null) {
            result = false;
        } else {
            ArrayList<String> intenionallyTrueOptionals = new ArrayList<String>();
            ArrayList<String> intenionallyImpliedTrueOptionals = new ArrayList<String>();
            ArrayList<String> intenionallyFalseOptionals = new ArrayList<String>();
            HashMap<String, List> blameIU = new HashMap<String, List>();
            NodeList iuElements = document.getElementsByTagName("required");
            int nUnits = iuElements.getLength();
            int i = 0;
            while (i < nUnits) {
                Node iuNode = iuElements.item(i);
                NamedNodeMap attributes = iuNode.getAttributes();
                String optional = this.getAttributeValue(attributes, "optional");
                if (optional != null) {
                    String namespace = this.getAttributeValue(attributes, "namespace");
                    String name = this.getAttributeValue(attributes, "name");
                    if (!name.endsWith(".feature.group") && !namespace.equals("org.eclipse.equinox.p2.eclipse.type")) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\tname: " + name);
                        stringBuffer.append("\t\t\t\tnamespace: ");
                        String shortname = null;
                        if (namespace.equals("osgi.bundle")) {
                            shortname = "bundle";
                        } else if (namespace.equals("java.package")) {
                            shortname = "package";
                        } else {
                            System.out.println("namespace: " + namespace);
                            shortname = namespace;
                        }
                        stringBuffer.append(shortname);
                        String greedy = this.getAttributeValue(attributes, "greedy");
                        if (greedy == null) {
                            stringBuffer.append("\tgreedy: true (implied)");
                            intenionallyImpliedTrueOptionals.add(name);
                            this.addBlameIU(blameIU, iuNode, name);
                        } else {
                            stringBuffer.append("\tgreedy: " + greedy);
                            if (greedy.equals("true")) {
                                intenionallyTrueOptionals.add(name);
                            } else {
                                intenionallyFalseOptionals.add(name);
                            }
                        }
                    }
                }
                ++i;
            }
            this.printHTMLReport(nUnits, intenionallyTrueOptionals, intenionallyImpliedTrueOptionals, intenionallyFalseOptionals, blameIU);
            result = true;
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        return result;
    }

    private void addBlameIU(Map<String, List> blameIU, Node iuNode, String name) {
        Node iuelement = this.walkbackToUnit(iuNode);
        String unitID = this.getID(iuelement);
        ArrayList<String> anodeList = blameIU.get(name);
        if (anodeList == null) {
            anodeList = new ArrayList<String>();
            anodeList.add(unitID);
            blameIU.put(name, anodeList);
        } else {
            anodeList.add(unitID);
        }
    }

    private String getID(Node iuelement) {
        NamedNodeMap attributes = iuelement.getAttributes();
        Node idattr = attributes.getNamedItem("id");
        String unitid = idattr.getNodeValue();
        return unitid;
    }

    private Node walkbackToUnit(Node iuNode) {
        if (iuNode.getNodeName().equals("unit")) {
            return iuNode;
        }
        Node pnode = iuNode.getParentNode();
        if (pnode == null) {
            return null;
        }
        return this.walkbackToUnit(pnode);
    }

    private void printHTMLReport(int nUnits, List<String> intenionallyTrueOptionals, List<String> intenionallyImpliedTrueOptionals, List<String> intenionallyFalseOptionals, Map<String, List> blameIUs) throws IOException {
        try (FileWriter outfile = this.createOutputFile();){
            List<Object> conflictingStatements = new ArrayList();
            conflictingStatements = this.overlapping(intenionallyFalseOptionals, intenionallyImpliedTrueOptionals);
            conflictingStatements.addAll(this.overlapping(intenionallyFalseOptionals, intenionallyTrueOptionals));
            int listsTotal = intenionallyFalseOptionals.size() + intenionallyImpliedTrueOptionals.size() + intenionallyTrueOptionals.size();
            this.printHeader(outfile, 1, "Report on optional runtime requirements and greediness");
            this.printparagraph(outfile, "Using repository content metadata from repo at " + this.getRepoURLToTest());
            this.printparagraph(outfile, "Total number of 'requried' elements found: " + nUnits);
            this.printparagraph(outfile, "Total number of 'requried' elements found with 'optional=\"true\"' attribute: " + listsTotal);
            this.printHeader(outfile, 2, "Probable problem. Conflicting specifications. (Intersection of other lists.) Optional runtime requirement sometimes with greedy install, sometimes not.");
            this.printLinesProvider(outfile, conflictingStatements, blameIUs);
            this.printHeader(outfile, 2, "Probable problem. Optional requirements with implicit greedy install (old publisher default)");
            this.printLinesProvider(outfile, intenionallyImpliedTrueOptionals, blameIUs);
            this.printHeader(outfile, 2, "Unusual cases, but assumed intended. Optional runtime requirement with explicit greedy install.");
            this.printLinesProvider(outfile, intenionallyTrueOptionals);
            this.printHeader(outfile, 2, "Correct cases. Optional runtime requirements with explicit no-greedy install (new publisher default)");
            this.printLinesProvider(outfile, intenionallyFalseOptionals);
        }
    }

    private List<String> overlapping(List<String> intenionallyFalseOptionals, List<String> intenionallyImpliedTrueOptionals) {
        HashSet<String> intersectionSet = new HashSet<String>();
        for (String nongreedyRequirement : intenionallyFalseOptionals) {
            if (!intenionallyImpliedTrueOptionals.contains(nongreedyRequirement)) continue;
            intersectionSet.add(nongreedyRequirement);
        }
        ArrayList<String> intersectionList = new ArrayList<String>(intersectionSet);
        return intersectionList;
    }

    private FileWriter createOutputFile() throws IOException {
        FileWriter outfileWriter = null;
        File outfile = null;
        String testDirName = this.getReportOutputDirectory();
        outfile = new File(testDirName, "greedyReport.html");
        System.out.println("output: " + outfile.getAbsolutePath());
        outfileWriter = new FileWriter(outfile);
        return outfileWriter;
    }

    private String getAttributeValue(NamedNodeMap attributes, String name) {
        String result = null;
        Node attrnode = attributes.getNamedItem(name);
        if (attrnode != null) {
            result = attrnode.getNodeValue();
        }
        return result;
    }

    private void printLinesProvider(FileWriter out, List<String> names) throws IOException {
        HashSet<String> namesSet = new HashSet<String>(names);
        out.write("<p>Total Count: " + names.size() + EOL);
        out.write("<p>Unique Count: " + namesSet.size() + EOL);
        out.write("<ol>" + EOL);
        ArrayList<String> sortedUniqueNames = new ArrayList<String>(namesSet);
        Collections.sort(sortedUniqueNames);
        for (String name : sortedUniqueNames) {
            this.printLineListItem(out, name);
        }
        out.write("</ol>" + EOL);
    }

    private void printLinesProvider(FileWriter out, List<String> names, Map<String, List> blameIUs) throws IOException {
        HashSet<String> namesSet = new HashSet<String>(names);
        out.write("<p>Total Count: " + names.size() + EOL);
        out.write("<p>Unique Count: " + namesSet.size() + EOL);
        out.write("<ol>" + EOL);
        ArrayList<String> sortedUniqueNames = new ArrayList<String>(namesSet);
        Collections.sort(sortedUniqueNames);
        for (String name : sortedUniqueNames) {
            this.printLineListItem(out, name);
            this.printInnerList(out, name, blameIUs);
        }
        out.write("</ol>" + EOL);
    }

    private void printInnerList(FileWriter out, String name, Map<String, List> blameIUs) throws IOException {
        List toblame = blameIUs.get(name);
        if (toblame == null) {
            return;
        }
        Collections.sort(toblame);
        out.write("<p>Number of IUs using optional, but greedy for this case: " + toblame.size() + EOL);
        out.write("<ol>" + EOL);
        for (Object iu : toblame) {
            this.printLineListItem(out, (String)iu);
        }
        out.write("</ol></p>" + EOL);
    }
}

