/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.cbi.p2repo.analyzers.utils.IUIdComparator;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.query.IQueryResult;

public class FeatureDisplayableDataChecker
extends TestRepo {
    private static String STANDARD_LICENSES_PROPERTIES_FILE = "standardLicenses.properties";
    private String previousPackageHeader = null;

    public FeatureDisplayableDataChecker(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static void main(String[] args) {
        FeatureDisplayableDataChecker._testFeatureDisplayableDataChecer();
        FeatureDisplayableDataChecker._testGetInitialSegments();
    }

    private static void _testFeatureDisplayableDataChecer() {
        System.out.println("\n\n\tLocal test of  FeatureDisplayableDataChecker.\n\n");
        FeatureDisplayableDataChecker featureDisplayableDataChecker = new FeatureDisplayableDataChecker(RepoTestsConfiguration.createFromSystemProperties());
        featureDisplayableDataChecker.setRepoURLToTest("file:///home/shared/simrel/luna/aggregation/final");
        featureDisplayableDataChecker.setMainOutputDirectory("/home/shared/simrel/luna");
        try {
            featureDisplayableDataChecker.testDisplayableData();
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void _testGetInitialSegments() {
        System.out.println("\n\n\tTesting getInitialSegments method.\n\n");
        FeatureDisplayableDataChecker instance = new FeatureDisplayableDataChecker(RepoTestsConfiguration.createFromSystemProperties());
        System.out.println(instance.getInitialSegments(""));
        System.out.println(instance.getInitialSegments("one"));
        System.out.println(instance.getInitialSegments("one.two"));
        System.out.println(instance.getInitialSegments("one.two.three"));
        System.out.println(instance.getInitialSegments("one.two.three.four"));
        System.out.println(instance.getInitialSegments("one.two.three.four.five"));
        System.out.println(instance.getInitialSegments("."));
        System.out.println(instance.getInitialSegments("one.two."));
    }

    private boolean checkLicenseConsistency(IQueryResult<IInstallableUnit> allFeatures) throws IOException {
        boolean result = false;
        Properties properties = new Properties();
        InputStream inStream = this.getClass().getResourceAsStream(STANDARD_LICENSES_PROPERTIES_FILE);
        properties.load(inStream);
        String body2014 = properties.getProperty("license2014");
        String body2011 = properties.getProperty("license2011");
        String body2010 = properties.getProperty("license2010");
        License standardLicense2014 = new License(null, body2014, null);
        License standardLicense2011 = new License(null, body2011, null);
        License standardLicense2010 = new License(null, body2010, null);
        ArrayList<IInstallableUnit> noLicense = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> extraLicense = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> license2014 = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> license2011 = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> license2010 = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> badLicense = new ArrayList<IInstallableUnit>();
        this.checkLicenses((ILicense)standardLicense2014, (ILicense)standardLicense2011, (ILicense)standardLicense2010, allFeatures, license2014, license2011, license2010, badLicense, noLicense, extraLicense);
        this.printReportLicense(license2014, license2011, license2010, badLicense, noLicense, extraLicense);
        result = badLicense.size() > 0 || extraLicense.size() > 0 || noLicense.size() > 0;
        return result;
    }

    private void checkLicenses(ILicense platformLicense2014, ILicense platformLicense2011, ILicense platformLicense2010, IQueryResult<IInstallableUnit> allFeatures, List<IInstallableUnit> license2014, List<IInstallableUnit> license2011, List<IInstallableUnit> license2010, List<IInstallableUnit> badLicense, List<IInstallableUnit> noLicense, List<IInstallableUnit> extraLicense) {
        System.out.println("Number of IUs during license check: " + allFeatures.toUnmodifiableSet().size());
        int nFeatures = 0;
        for (IInstallableUnit feature : allFeatures.toUnmodifiableSet()) {
            ++nFeatures;
            Collection licenses = feature.getLicenses(null);
            if (licenses.isEmpty()) {
                noLicense.add(feature);
                continue;
            }
            if (licenses.size() != 1) {
                extraLicense.add(feature);
                continue;
            }
            ILicense featureLicense = (ILicense)licenses.iterator().next();
            if (platformLicense2010.getUUID().equals(featureLicense.getUUID())) {
                license2010.add(feature);
                continue;
            }
            if (platformLicense2011.getUUID().equals(featureLicense.getUUID())) {
                license2011.add(feature);
                continue;
            }
            if (platformLicense2014.getUUID().equals(featureLicense.getUUID())) {
                license2014.add(feature);
                continue;
            }
            String featureLicenseText = featureLicense.getBody();
            if (featureLicenseText == null || featureLicenseText.length() == 0) {
                noLicense.add(feature);
            }
            badLicense.add(feature);
        }
        System.out.println("Number features or products during license check: " + nFeatures);
    }

    private void printReportLicense(List<IInstallableUnit> license2014, List<IInstallableUnit> license2011, List<IInstallableUnit> license2010, List<IInstallableUnit> badLicense, List<IInstallableUnit> noLicense, List<IInstallableUnit> extraLicense) {
        block17: {
            OutputStreamWriter outfileWriter = null;
            File outfile = null;
            String testDirName = this.getReportOutputDirectory();
            try {
                try {
                    outfile = new File(testDirName, "licenseConsistency.html");
                    outfileWriter = new FileWriter(outfile);
                    this.printparagraph((FileWriter)outfileWriter, "Repository ('repoURLToTest'): " + this.getRepoURLToTest());
                    this.printparagraph((FileWriter)outfileWriter, "\toutput: " + outfile.getAbsolutePath());
                    this.printHeader((FileWriter)outfileWriter, 2, "License Consistency Summary");
                    this.println((FileWriter)outfileWriter, "Features with conforming (2014) license: " + license2014.size());
                    this.println((FileWriter)outfileWriter, "Features with old (2011) license: " + license2011.size());
                    this.println((FileWriter)outfileWriter, "Features with old (2010) license: " + license2010.size());
                    this.println((FileWriter)outfileWriter, "Features with different (or no) license: " + badLicense.size());
                    this.println((FileWriter)outfileWriter, "Features with no license attribute: " + noLicense.size());
                    this.println((FileWriter)outfileWriter, "Features with extra licenses: " + extraLicense.size());
                    this.printHeader((FileWriter)outfileWriter, 2, "Details");
                    this.printHeader((FileWriter)outfileWriter, 3, "Features with no license attribute");
                    Collections.sort(noLicense, new IUIdComparator());
                    for (IInstallableUnit unit : noLicense) {
                        this.println((FileWriter)outfileWriter, this.printableIdString(unit));
                    }
                    this.printHeader((FileWriter)outfileWriter, 3, "Features with different (or no) license (and first few lines of license text)");
                    Collections.sort(badLicense, new IUIdComparator());
                    for (IInstallableUnit unit : badLicense) {
                        this.makeHeaderIfNeeded((FileWriter)outfileWriter, unit.getId());
                        this.println((FileWriter)outfileWriter, this.printableIdString(unit));
                        Collection licenses = unit.getLicenses();
                        ILicense featureLicense = (ILicense)licenses.iterator().next();
                        String licenseText = featureLicense.getBody();
                        int amount = Math.min(200, licenseText.length());
                        String shortLicenseText = licenseText.substring(0, amount);
                        this.printparagraph((FileWriter)outfileWriter, shortLicenseText);
                    }
                    this.printHeader((FileWriter)outfileWriter, 3, "Features with old (2010) license");
                    Collections.sort(license2010, new IUIdComparator());
                    for (IInstallableUnit unit : license2010) {
                        this.println((FileWriter)outfileWriter, this.printableIdString(unit));
                    }
                    this.printHeader((FileWriter)outfileWriter, 3, "Features with old (2011) license");
                    Collections.sort(license2011, new IUIdComparator());
                    for (IInstallableUnit unit : license2011) {
                        this.println((FileWriter)outfileWriter, this.printableIdString(unit));
                    }
                    this.printHeader((FileWriter)outfileWriter, 3, "Features with current (2014) license");
                    Collections.sort(license2014, new IUIdComparator());
                    for (IInstallableUnit unit : license2014) {
                        this.println((FileWriter)outfileWriter, this.printableIdString(unit));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (outfileWriter == null) break block17;
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (outfileWriter != null) {
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String printableIdString(IInstallableUnit unit) {
        String printIdString = unit.getId();
        String productString = unit.getProperty("org.eclipse.equinox.p2.type.product");
        boolean productValue = "true".equals(productString);
        if (productValue) {
            printIdString = String.valueOf(printIdString) + " [Product]";
        }
        return printIdString;
    }

    private void makeHeaderIfNeeded(FileWriter outputfile, String id) throws IOException {
        String proposedHeader = this.getInitialSegments(id);
        if (proposedHeader == null || proposedHeader.length() == 0) {
            proposedHeader = "Unexpectedly empty package name?";
        }
        if (this.previousPackageHeader == null || !this.previousPackageHeader.equals(proposedHeader)) {
            this.previousPackageHeader = proposedHeader;
            this.printHeader(outputfile, 4, proposedHeader);
        }
    }

    private String getInitialSegments(String id) {
        String[] proposedHeaderArray;
        String proposedHeader = "";
        if (id != null && id.length() != 0 && (proposedHeaderArray = id.split("\\.")).length > 0) {
            int nSegments = Math.min(proposedHeaderArray.length, 3);
            int i = 0;
            do {
                if (proposedHeader.length() != 0) {
                    proposedHeader = String.valueOf(proposedHeader) + ".";
                }
                proposedHeader = String.valueOf(proposedHeader) + proposedHeaderArray[i];
            } while (++i < nSegments);
        }
        return proposedHeader;
    }

    public boolean testDisplayableData() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        boolean result = false;
        IQueryResult<IInstallableUnit> allIUs = this.getAllGroupIUs();
        result = this.checkLicenseConsistency(allIUs);
        result |= this.checkCopyrights(allIUs);
        return result |= this.checkDescriptions(allIUs);
    }

    private boolean checkCopyrights(IQueryResult<IInstallableUnit> allFeatures) {
        boolean result = false;
        ArrayList<IInstallableUnit> noOrBadCopyright = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> okCopyright = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> indeterminateCopyright = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit feature : allFeatures.toUnmodifiableSet()) {
            if (!feature.getId().endsWith(".feature.group")) continue;
            ICopyright copyright = feature.getCopyright(null);
            if (copyright == null) {
                noOrBadCopyright.add(feature);
                continue;
            }
            String body = copyright.getBody();
            if (body == null || body.length() == 0 || body.startsWith("%") || body.startsWith("[")) {
                noOrBadCopyright.add(feature);
                continue;
            }
            if (body.startsWith("Copyright") || body.startsWith("(c) Copyright")) {
                okCopyright.add(feature);
                continue;
            }
            if (body.contains("Copyright") || body.contains("copyright")) {
                indeterminateCopyright.add(feature);
                continue;
            }
            noOrBadCopyright.add(feature);
        }
        this.printReportCopyrights(okCopyright, noOrBadCopyright, indeterminateCopyright);
        result = noOrBadCopyright.size() > 0;
        return result;
    }

    private boolean checkDescriptions(IQueryResult<IInstallableUnit> allFeatures) {
        boolean result = false;
        ArrayList<IInstallableUnit> noneOrBad = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> ok = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit feature : allFeatures.toUnmodifiableSet()) {
            if (!feature.getId().endsWith(".feature.group")) continue;
            String description = feature.getProperty("org.eclipse.equinox.p2.description", null);
            if (description == null || description.length() <= 0 || description.startsWith("%")) {
                noneOrBad.add(feature);
                continue;
            }
            ok.add(feature);
        }
        this.printReportDescription(ok, noneOrBad);
        result = noneOrBad.size() > 0;
        return result;
    }

    private void printReportDescription(List<IInstallableUnit> ok, List<IInstallableUnit> noneOrBad) {
        block14: {
            String SPACER = "<br />=======================";
            OutputStreamWriter outfileWriter = null;
            File outfile = null;
            String testDirName = this.getReportOutputDirectory();
            try {
                try {
                    outfile = new File(testDirName, "descriptions.html");
                    outfileWriter = new FileWriter(outfile);
                    System.out.println("output: " + outfile.getAbsolutePath());
                    this.println((FileWriter)outfileWriter, "<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
                    this.println((FileWriter)outfileWriter, "<br /><br />Description Report:" + SPACER);
                    this.println((FileWriter)outfileWriter, "Features wrong or unexplainable descriptions: " + noneOrBad.size());
                    this.println((FileWriter)outfileWriter, "Features probably correct: " + ok.size());
                    this.println((FileWriter)outfileWriter, "=======================");
                    this.println((FileWriter)outfileWriter, "<br /><br />Details:" + SPACER);
                    this.println((FileWriter)outfileWriter, "Features with no or dubious descripiton:" + SPACER);
                    Collections.sort(noneOrBad, new IUIdComparator());
                    for (IInstallableUnit unit : noneOrBad) {
                        this.printLineDescription((FileWriter)outfileWriter, unit);
                    }
                    this.println((FileWriter)outfileWriter, "<br /><br />Features with descripitons:" + SPACER);
                    Collections.sort(ok, new IUIdComparator());
                    for (IInstallableUnit unit : ok) {
                        this.printLineDescription((FileWriter)outfileWriter, unit);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (outfileWriter == null) break block14;
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (outfileWriter != null) {
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void printReportCopyrights(List<IInstallableUnit> good, List<IInstallableUnit> bad, List<IInstallableUnit> maybe) {
        block15: {
            String SPACER = "<br />=======================";
            OutputStreamWriter outfileWriter = null;
            File outfile = null;
            String testDirName = this.getReportOutputDirectory();
            try {
                try {
                    outfile = new File(testDirName, "copyrights.html");
                    outfileWriter = new FileWriter(outfile);
                    System.out.println("output: " + outfile.getAbsolutePath());
                    this.println((FileWriter)outfileWriter, "<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
                    this.println((FileWriter)outfileWriter, "<br /><br />Copyright Report:" + SPACER);
                    this.println((FileWriter)outfileWriter, "Features wrong or unexplainable copyrights: " + bad.size());
                    this.println((FileWriter)outfileWriter, "Features maybe wrong, maybe correct copyrights: " + maybe.size());
                    this.println((FileWriter)outfileWriter, "Features probably correct: " + good.size());
                    this.println((FileWriter)outfileWriter, "=======================");
                    this.println((FileWriter)outfileWriter, "<br /><br />Details:" + SPACER);
                    this.println((FileWriter)outfileWriter, "Features with no or probably incorrect copyright statement:" + SPACER);
                    Collections.sort(bad, new IUIdComparator());
                    for (IInstallableUnit unit : bad) {
                        this.printLineCopyright((FileWriter)outfileWriter, unit);
                    }
                    this.println((FileWriter)outfileWriter, "<br /><br />Indeterminant: feature's copyright text contains the word 'copyright' but not at beginning:" + SPACER);
                    Collections.sort(maybe, new IUIdComparator());
                    for (IInstallableUnit unit : maybe) {
                        this.printLineCopyright((FileWriter)outfileWriter, unit);
                    }
                    this.println((FileWriter)outfileWriter, "<br /><br />Features with copyrights that are probably ok (i.e. start with 'Copyright'):" + SPACER);
                    Collections.sort(good, new IUIdComparator());
                    for (IInstallableUnit unit : good) {
                        this.printLineCopyright((FileWriter)outfileWriter, unit);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (outfileWriter == null) break block15;
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (outfileWriter != null) {
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void printLineCopyright(FileWriter outfileWriter, IInstallableUnit iu) throws IOException {
        String copyright = null;
        ICopyright copyrightIu = iu.getCopyright(null);
        if (copyrightIu != null) {
            copyright = copyrightIu.getBody();
        }
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        this.println(outfileWriter, String.valueOf(iuId) + " &nbsp; " + iuVersion + BR + " &nbsp; " + copyright);
    }

    private void printLineDescription(FileWriter outfileWriter, IInstallableUnit iu) throws IOException {
        String description = iu.getProperty("org.eclipse.equinox.p2.description", null);
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        this.println(outfileWriter, String.valueOf(iuId) + " &nbsp; " + iuVersion + BR + " &nbsp; " + description);
    }
}

