/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.cbi.p2repo.analyzers.utils.StringLengthComparator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;

public class FeatureNameLengths
extends TestRepo {
    private Map distribution = null;
    public static final int MAX_CRITERIA = 100;
    private List longestNames = new ArrayList();

    public FeatureNameLengths(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public static void main(String[] args) {
        FeatureNameLengths featureNameLengths = new FeatureNameLengths(RepoTestsConfiguration.createFromSystemProperties());
        featureNameLengths.setRepoURLToTest("/home/files/buildzips/junoRC3/wtp-repo");
        featureNameLengths.setMainOutputDirectory("/temp");
        try {
            featureNameLengths.testFeatureDirectoryLength();
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void analyze(IQueryResult<IInstallableUnit> allIUs) {
        this.distribution = new HashMap();
        for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
            String featureName = iu.getId();
            String featureGroup = ".feature.group";
            int featureGroupLength = featureGroup.length();
            if (featureName.endsWith(featureGroup)) {
                featureName = featureName.substring(0, featureName.length() - featureGroupLength);
            }
            String line = String.valueOf(featureName) + "_" + iu.getVersion();
            this.tabulate(line.length());
            if (line.length() <= 100) continue;
            this.longestNames.add(line);
        }
    }

    private void printReport() throws IOException {
        String SPACER = "<br />=======================";
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "featureDirectoryLengths.html");
            outfileWriter = new FileWriter(outfile);
            this.println((FileWriter)outfileWriter, "<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
            this.println((FileWriter)outfileWriter, "<br /><br />Distribution of Feature Directory Lengths:" + SPACER);
            Integer total = new Integer(0);
            Set keys = this.distribution.keySet();
            List<Integer> list = FeatureNameLengths.asSortedList(keys);
            for (Integer category : list) {
                Integer count = (Integer)this.distribution.get(category);
                this.println((FileWriter)outfileWriter, " &nbsp; " + category + " &nbsp; " + count);
                total = total + count;
            }
            this.println((FileWriter)outfileWriter, "=======================" + EOL);
            this.println((FileWriter)outfileWriter, " &nbsp; Total features directory names: " + total + EOL);
            this.println((FileWriter)outfileWriter, "=======================" + EOL);
            if (this.longestNames.size() > 0) {
                this.println((FileWriter)outfileWriter, " &nbsp; Features directory names with lengths above 100" + EOL);
                Collections.sort(this.longestNames, new StringLengthComparator());
                int i = 0;
                while (i < this.longestNames.size()) {
                    String line = (String)this.longestNames.get(i);
                    this.println((FileWriter)outfileWriter, String.valueOf(line.length()) + " &nbsp; " + line + EOL);
                    ++i;
                }
            } else {
                this.println((FileWriter)outfileWriter, " &nbsp;  No feature directory names lengths were longer than the maxCriteria, 100" + EOL);
            }
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void tabulate(int length) {
        Integer category = new Integer(length);
        Integer count = (Integer)this.distribution.get(category);
        count = count == null ? new Integer(1) : Integer.valueOf(count + 1);
        this.distribution.put(category, count);
    }

    public int testFeatureDirectoryLength() throws ProvisionException, URISyntaxException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllGroupIUs();
        return this.checkFeatureDirLenths(allIUs);
    }

    private int checkFeatureDirLenths(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        this.analyze(allIUs);
        this.printReport();
        return this.longestNames.size();
    }
}

