/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.cbi.p2repo.analyzers.utils.IUIdComparator;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;

public class IUNameChecker
extends TestRepo {
    public IUNameChecker(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public boolean testBundleNames() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUs();
        return this.checkBundleNames(allIUs);
    }

    public boolean testFeatureNames() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllGroupIUs();
        return this.checkFeatureNames(allIUs);
    }

    private boolean checkFeatureNames(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> incorrectBundleName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> probablyCorrectBundleName = new ArrayList<IInstallableUnit>();
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "featureNames.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
                try {
                    boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
                    boolean isFragment = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.fragment"));
                    if (!this.isGroup(iu) || isCategory || this.isSpecial(iu) || isFragment || this.isEclipseLicenseIU(iu)) continue;
                    String bundleName = iu.getProperty("org.eclipse.equinox.p2.name", null);
                    if (bundleName == null) {
                        incorrectBundleName.add(iu);
                        continue;
                    }
                    if (bundleName.startsWith("%") || bundleName.startsWith("Feature-") || bundleName.startsWith("Bundle-") || bundleName.startsWith("feature") || bundleName.startsWith("plugin") || bundleName.startsWith("Plugin.name") || bundleName.startsWith("fragment.") || bundleName.startsWith("Eclipse.org") || bundleName.startsWith("bundle")) {
                        incorrectBundleName.add(iu);
                        continue;
                    }
                    probablyCorrectBundleName.add(iu);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            outfileWriter.write("<h1>Feature names used in repository</h1>" + EOL);
            outfileWriter.write("<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
            outfileWriter.write("<h2>Major: missing or (probably) incorrect names</h2>" + EOL);
            this.printLinesBundleName((FileWriter)outfileWriter, incorrectBundleName);
            outfileWriter.write("<h2>Probably correct names</h2>" + EOL);
            this.printLinesBundleName((FileWriter)outfileWriter, probablyCorrectBundleName);
            boolean bl = incorrectBundleName.size() > 0;
            return bl;
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean checkBundleNames(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> incorrectBundleName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> probablyCorrectBundleName = new ArrayList<IInstallableUnit>();
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "bundleNames.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
                try {
                    boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
                    boolean isFragment = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.fragment"));
                    if (isCategory || this.isSpecial(iu) || isFragment || this.isGroup(iu) || this.isEclipseLicenseIU(iu)) continue;
                    String bundleName = iu.getProperty("org.eclipse.equinox.p2.name", null);
                    if (bundleName == null) {
                        incorrectBundleName.add(iu);
                        continue;
                    }
                    if (bundleName.startsWith("%") || bundleName.startsWith("Bundle-") || bundleName.startsWith("plugin") || bundleName.startsWith("Plugin.name") || bundleName.startsWith("fragment.") || bundleName.startsWith("Eclipse.org") || bundleName.startsWith("bundle")) {
                        incorrectBundleName.add(iu);
                        continue;
                    }
                    probablyCorrectBundleName.add(iu);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            outfileWriter.write("<h1>Bundle names used in repository</h1>" + EOL);
            outfileWriter.write("<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
            outfileWriter.write("<h2>Major: missing or (probably) incorrect bundle name</h2>" + EOL);
            this.printLinesBundleName((FileWriter)outfileWriter, incorrectBundleName);
            outfileWriter.write("<h2>Probably correct bundle name</h2>" + EOL);
            this.printLinesBundleName((FileWriter)outfileWriter, probablyCorrectBundleName);
            boolean bl = incorrectBundleName.size() > 0;
            return bl;
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printLinesBundleName(FileWriter out, List<IInstallableUnit> iuList) throws IOException {
        IUIdComparator comparatorBundleName = new IUIdComparator();
        Collections.sort(iuList, comparatorBundleName);
        out.write("<p>Count: " + iuList.size() + EOL);
        out.write("<ol>" + EOL);
        for (IInstallableUnit iu : iuList) {
            this.printLineListItem(out, iu, "org.eclipse.equinox.p2.name");
        }
        out.write("</ol>" + EOL);
    }
}

