/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.cbi.p2repo.analyzers.utils.IUIdComparator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;

public class IUVersionCheckToReference
extends TestRepo {
    public IUVersionCheckToReference(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public boolean checkIUVersionsToReference() throws IOException, ProvisionException, URISyntaxException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> referenceOnly = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> newIUs = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> decreasingVersions = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> matchingVersions = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsMajor = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsMinor = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsService = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsQualifierOnly = new ArrayList<IInstallableUnit>();
        TreeSet refinboth = new TreeSet();
        TreeSet<String> curinboth = new TreeSet<String>();
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "versionChecks.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            outfileWriter.write("<h1>All IUs</h1>" + EOL + "<p>(except groups, and categories)</p>");
            outfileWriter.write("<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
            if (this.getRepoURLForReference().length() > 0) {
                outfileWriter.write("<p>Repository for reference ('repoURLForReference'): " + this.getRepoURLForReference() + "</p>" + EOL);
            }
            System.out.println("Number in reference from raw count:" + this.rawcount(this.getAllReferenceIUs()));
            if (this.getAllReferenceIUs() != null) {
                System.out.println("Number in reference from set:" + this.getAllReferenceIUs().toSet().size());
            }
            System.out.println("Number in current from raw count:" + this.rawcount(this.getAllIUs()));
            System.out.println("Number in current from set: " + this.getAllIUs().toSet().size());
            this.processForExtraReferences(referenceOnly, refinboth);
            System.out.println("Number in reference missing from current: " + referenceOnly.size());
            System.out.println("Number in common in reference and current: " + refinboth.size());
            this.processForNewBundles(newIUs, curinboth);
            System.out.println("Number in current missing from reference: " + newIUs.size());
            System.out.println("Number in common in reference and current: " + curinboth.size());
            outfileWriter.write("<h2>IUs in reference, but not in current repo</h2>" + EOL);
            this.printLinesIUs((FileWriter)outfileWriter, referenceOnly);
            outfileWriter.write("<h2>IUs in current, but not in reference</h2>" + EOL);
            this.printLinesIUs((FileWriter)outfileWriter, newIUs);
            this.processForDifferences(curinboth, this.getAllIUs(), this.getAllReferenceIUs(), decreasingVersions, matchingVersions, increaseVersionsMajor, increaseVersionsMinor, increaseVersionsService, increaseVersionsQualifierOnly);
            outfileWriter.write("<h2>IUs in current repo that decrease versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, decreasingVersions, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase major versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsMajor, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase minor versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsMinor, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase versions but with qualifier only</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsQualifierOnly, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase service versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsService, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that have matching versions in reference repo</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, matchingVersions, this.getAllReferenceIUs());
            return true;
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processForDifferences(Set<String> curinboth, IQueryResult<IInstallableUnit> allIUs, IQueryResult<IInstallableUnit> allReferenceIUs, List<IInstallableUnit> decreasingVersions, List<IInstallableUnit> matchingVersions, List<IInstallableUnit> increaseVersionsMajor, List<IInstallableUnit> increaseVersionsMinor, List<IInstallableUnit> increaseVersionsService, List<IInstallableUnit> increaseVersionsQualifierOnly) {
        Set allCurrent = allIUs.toUnmodifiableSet();
        Set allRef = allReferenceIUs.toUnmodifiableSet();
        for (String iuname : curinboth) {
            Comparable refQualifier;
            Comparable refService;
            Comparable refMinor;
            Comparable refMajor;
            Version refVersion;
            IInstallableUnit current = this.getIU(iuname, allCurrent);
            IInstallableUnit reference = this.getIU(iuname, allRef);
            if (reference == null) continue;
            Version curVersion = current.getVersion();
            if (curVersion.equals(refVersion = reference.getVersion())) {
                matchingVersions.add(current);
                continue;
            }
            Comparable curMajor = curVersion.getSegment(0);
            if (curMajor.compareTo(refMajor = refVersion.getSegment(0)) < 0) {
                decreasingVersions.add(current);
                continue;
            }
            if (curMajor.compareTo(refMajor) > 0) {
                increaseVersionsMajor.add(current);
                continue;
            }
            if (curMajor.compareTo(refMajor) != 0) continue;
            Comparable curMinor = curVersion.getSegment(1);
            if (curMinor.compareTo(refMinor = refVersion.getSegment(1)) < 0) {
                decreasingVersions.add(current);
                continue;
            }
            if (curMinor.compareTo(refMinor) > 0) {
                increaseVersionsMinor.add(current);
                continue;
            }
            if (curMinor.compareTo(refMinor) != 0) continue;
            Comparable curService = curVersion.getSegment(2);
            if (curService.compareTo(refService = refVersion.getSegment(2)) < 0) {
                decreasingVersions.add(current);
                continue;
            }
            if (curService.compareTo(refService) > 0) {
                increaseVersionsService.add(current);
                continue;
            }
            if (curService.compareTo(refService) != 0) continue;
            Comparable curQualifier = curVersion.getSegment(3);
            if (curQualifier.compareTo(refQualifier = refVersion.getSegment(3)) < 0) {
                decreasingVersions.add(current);
                continue;
            }
            if (curQualifier.compareTo(refQualifier) > 0) {
                increaseVersionsQualifierOnly.add(current);
                continue;
            }
            if (curQualifier.compareTo(refQualifier) != 0) continue;
            System.out.print("Surprising we'd get here, since already checked for equality");
            matchingVersions.add(current);
        }
    }

    private IInstallableUnit getIU(String iuname, Set allIUs) {
        IInstallableUnit result = null;
        for (IInstallableUnit iu : allIUs) {
            if (!iuname.equals(iu.getId())) continue;
            result = iu;
            break;
        }
        return result;
    }

    private int rawcount(IQueryResult<IInstallableUnit> refs) {
        int count = 0;
        if (refs != null) {
            for (IInstallableUnit iiu : refs) {
                if (iiu.getId() == null || iiu.getId().length() == 0) {
                    throw new RuntimeException("IIU had no (or empty) ID string: " + iiu);
                }
                ++count;
            }
        }
        return count;
    }

    private void dump(List<IInstallableUnit> refinboth, String filename) throws IOException {
        Collections.sort(refinboth);
        try (OutputStreamWriter outfile = null;){
            File out = new File(this.getReportOutputDirectory(), filename);
            outfile = new FileWriter(out);
            for (IInstallableUnit iInstallableUnit : refinboth) {
                outfile.write(String.valueOf(iInstallableUnit.toString()) + EOL);
            }
        }
    }

    private void dump(Set<String> inboth, String filename) throws IOException {
        try (OutputStreamWriter outfile = null;){
            File out = new File(this.getReportOutputDirectory(), filename);
            outfile = new FileWriter(out);
            for (String iInstallableUnit : inboth) {
                outfile.write(String.valueOf(iInstallableUnit.toString()) + EOL);
            }
        }
    }

    private void processForNewBundles(List<IInstallableUnit> newIUs, Set<String> curinboth) throws ProvisionException, URISyntaxException {
        for (IInstallableUnit curiu : this.getAllIUs().toSet()) {
            if (this.isCategory(curiu) || this.isGroup(curiu)) continue;
            this.checkforNewInCurrent(curiu, newIUs, curinboth);
        }
    }

    private void processForExtraReferences(List<IInstallableUnit> referenceOnly, Set refinboth) throws ProvisionException, URISyntaxException {
        if (this.getAllReferenceIUs() != null) {
            for (IInstallableUnit refiu : this.getAllReferenceIUs().toSet()) {
                if (this.isCategory(refiu) || this.isGroup(refiu)) continue;
                this.checkforExtraReferences(refiu, referenceOnly, refinboth);
            }
        }
    }

    private void checkforNewInCurrent(IInstallableUnit curiu, List<IInstallableUnit> newIUs, Set<String> curinboth) throws ProvisionException, URISyntaxException {
        String curiuID = curiu.getId();
        if (curiuID == null) {
            System.out.println("iuID was unexpected null:" + curiu);
        } else {
            boolean foundMatch = false;
            if (this.getAllReferenceIUs() != null) {
                for (IInstallableUnit iu : this.getAllReferenceIUs().toSet()) {
                    if (!curiuID.equals(iu.getId())) continue;
                    foundMatch = true;
                    break;
                }
            }
            if (foundMatch) {
                curinboth.add(curiu.getId());
            } else {
                newIUs.add(curiu);
            }
        }
    }

    private void checkforExtraReferences(IInstallableUnit refiu, List<IInstallableUnit> referenceOnly, Set<String> inboth) throws ProvisionException, URISyntaxException {
        String refiuID = refiu.getId();
        if (refiuID == null) {
            System.out.println("iuID was unexpected null:" + refiu);
        } else {
            boolean foundMatch = false;
            for (IInstallableUnit iu : this.getAllIUs().toSet()) {
                if (!refiuID.equals(iu.getId())) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) {
                inboth.add(refiu.getId());
            } else {
                referenceOnly.add(refiu);
            }
        }
    }

    private void printLinesIUs(FileWriter out, List<IInstallableUnit> iuList) throws IOException {
        IUIdComparator comparatorBundleName = new IUIdComparator();
        Collections.sort(iuList, comparatorBundleName);
        out.write("<p>Count: " + iuList.size() + EOL);
        out.write("<ol>" + EOL);
        for (IInstallableUnit iu : iuList) {
            this.printLineListItem(out, iu, "org.eclipse.equinox.p2.name");
        }
        out.write("</ol>" + EOL);
    }

    private void printTableIUs(FileWriter out, List<IInstallableUnit> iuListCur, IQueryResult<IInstallableUnit> iuListRefs) throws IOException {
        out.write("<p>Count: " + iuListCur.size() + EOL);
        if (iuListCur.size() > 0) {
            Collections.sort(iuListCur);
            this.printStartTable(out, "");
            this.printRowln(out, "<th>IU id</th><th>Reference (old) version</th><th>Current (new) version</th>");
            for (IInstallableUnit curInstallableUnit : iuListCur) {
                IInstallableUnit refIInstallableUnit = this.getIUNamed(iuListRefs, curInstallableUnit.getId());
                this.printLineRowItem(out, curInstallableUnit, refIInstallableUnit);
            }
            this.printEndTable(out);
        }
    }

    private IInstallableUnit getIUNamed(IQueryResult<IInstallableUnit> iuListRefs, String id) {
        IInstallableUnit result = null;
        for (IInstallableUnit iInstallableUnit : iuListRefs) {
            if (!iInstallableUnit.getId().equals(id)) continue;
            result = iInstallableUnit;
            break;
        }
        return result;
    }

    public boolean checkIUVersionsToReferenceForFeatures() throws IOException, ProvisionException, URISyntaxException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> inreferenceOnly = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> newIUs = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> decreasingVersions = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> matchingVersions = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsMajor = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsMinor = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsService = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> increaseVersionsQualifierOnly = new ArrayList<IInstallableUnit>();
        TreeSet<String> refinboth = new TreeSet<String>();
        TreeSet<String> curinboth = new TreeSet<String>();
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "versionChecksFeatures.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            System.out.println("all feature groups IUs");
            System.out.println("Number in reference from raw count:" + this.rawcount(this.getAllReferenceGroupIUs()));
            if (this.getAllReferenceGroupIUs() != null) {
                System.out.println("Number in reference from set: " + this.getAllReferenceGroupIUs().toSet().size());
            }
            System.out.println("Number in current from raw count:" + this.rawcount(this.getAllGroupIUs()));
            System.out.println("Number in current from set: " + this.getAllGroupIUs().toSet().size());
            this.processForExtraReferencesFeatures(inreferenceOnly, refinboth);
            System.out.println("Number in reference missing from current: " + inreferenceOnly.size());
            System.out.println("Number in common in reference and current: " + refinboth.size());
            this.dump(inreferenceOnly, "inRefererenceOnly.txt");
            this.dump(refinboth, "inBothRefFeatures.txt");
            this.processForNewFeatures(newIUs, curinboth);
            System.out.println("Number in current missing from reference: " + newIUs.size());
            System.out.println("Number in common in reference and current: " + curinboth.size());
            this.dump(newIUs, "newInCurrent.txt");
            this.dump(curinboth, "inBothCurrentFeatures.txt");
            outfileWriter.write("<h1>feature.group IU changes</h1>" + EOL);
            outfileWriter.write("<p>Current Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
            if (this.getRepoURLForReference().length() > 0) {
                outfileWriter.write("<p>Repository for reference ('repoURLForReference'): " + this.getRepoURLForReference() + "</p>" + EOL);
            }
            outfileWriter.write("<h2>IUs in reference repo, but not current repo</h2>" + EOL);
            this.printLinesIUs((FileWriter)outfileWriter, inreferenceOnly);
            outfileWriter.write("<h2>IUs in current repo, but not reference repo</h2>" + EOL);
            this.printLinesIUs((FileWriter)outfileWriter, newIUs);
            this.processForDifferences(curinboth, this.getAllGroupIUs(), this.getAllReferenceGroupIUs(), decreasingVersions, matchingVersions, increaseVersionsMajor, increaseVersionsMinor, increaseVersionsService, increaseVersionsQualifierOnly);
            outfileWriter.write("<h2>IUs in current repo that decrease versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, decreasingVersions, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase major versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsMajor, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase minor versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsMinor, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase versions but with qualifier only</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsQualifierOnly, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that increase service versions</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, increaseVersionsService, this.getAllReferenceIUs());
            outfileWriter.write("<h2>IUs in current repo that have matching versions in reference repo</h2>" + EOL);
            this.printTableIUs((FileWriter)outfileWriter, matchingVersions, this.getAllReferenceIUs());
            return true;
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processForExtraReferencesFeatures(List<IInstallableUnit> referenceOnly, Set<String> refinboth) throws ProvisionException, URISyntaxException {
        if (this.getAllReferenceIUs() != null) {
            for (IInstallableUnit refiu : this.getAllReferenceIUs().toSet()) {
                if (!this.isGroup(refiu)) continue;
                this.checkforExtraReferences(refiu, referenceOnly, refinboth);
            }
        }
    }

    private void processForNewFeatures(List<IInstallableUnit> newIUs, Set<String> curinboth) throws ProvisionException, URISyntaxException {
        for (IInstallableUnit curiu : this.getAllGroupIUs().toSet()) {
            if (this.isGroup(curiu)) {
                this.checkforNewInCurrent(curiu, newIUs, curinboth);
                continue;
            }
            throw new RuntimeException("Feature group (from get groupIUs) does not end with feature.group: " + curiu);
        }
    }
}

