/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.cbi.p2repo.analyzers.utils.IUIdComparator;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;

public class ProviderNameChecker
extends TestRepo {
    private static final String OLD_PROVIDER_NAME = "Eclipse.org";
    private static final String KNOWN_PROVIDERS_RESOURCE = "knownProviders.properties";
    private static final String EXPECTED_PROVIDER_NAMES_KEY = "expectedProviderNames";
    private ArrayList<String> expectedProvidersName = null;

    public ProviderNameChecker(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    private boolean checkProviderNames(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> incorrectProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> correctProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> oldProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> unknownProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> suspectProviderName = new ArrayList<IInstallableUnit>();
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "providerNames.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
                try {
                    boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
                    boolean isFragment = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.fragment"));
                    boolean isProduct = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.product"));
                    if (isCategory || this.isSpecial(iu) || isFragment || isProduct || this.isEclipseLicenseIU(iu)) continue;
                    String providerName = iu.getProperty("org.eclipse.equinox.p2.provider", null);
                    if (providerName == null) {
                        incorrectProviderName.add(iu);
                        continue;
                    }
                    if (providerName.startsWith("%") || providerName.equals("Eclipse") || providerName.startsWith("eclipse.org") || providerName.equals("unknown") || providerName.startsWith("Engineering") || providerName.contains("org.eclipse.jwt") || providerName.contains("www.example.org") || providerName.contains("www.eclipse.org") || providerName.contains("Provider") || providerName.contains("provider") || providerName.startsWith("Bundle-") || providerName.startsWith("bund") || providerName.startsWith("Eclispe")) {
                        incorrectProviderName.add(iu);
                        continue;
                    }
                    if (providerName.startsWith("Eclipse.org - ")) {
                        correctProviderName.add(iu);
                        continue;
                    }
                    if (this.inListOfExpectedName(providerName)) {
                        correctProviderName.add(iu);
                        continue;
                    }
                    if (OLD_PROVIDER_NAME.equals(providerName)) {
                        oldProviderName.add(iu);
                        continue;
                    }
                    if (providerName.startsWith("Eclipse")) {
                        unknownProviderName.add(iu);
                        continue;
                    }
                    if (iu.getId().startsWith("org.eclipse")) {
                        suspectProviderName.add(iu);
                        continue;
                    }
                    unknownProviderName.add(iu);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            outfileWriter.write("<h1>Provider names used in repository</h1>" + EOL);
            outfileWriter.write("<p>Repository ('repoURLToTest'): " + this.getRepoURLToTest() + "</p>" + EOL);
            outfileWriter.write("<h2>Major: Suspect or (probably) incorrect provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, suspectProviderName);
            outfileWriter.write("<h2>Major: missing or (probably) incorrect provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, incorrectProviderName);
            outfileWriter.write("<h2>Indeterminate: maybe correct, maybe incorrect provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, unknownProviderName);
            outfileWriter.write("<h2>Old style provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, oldProviderName);
            outfileWriter.write("<h2>Probably using correctly branding provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, correctProviderName);
            outfileWriter.write("<h2>List of known branding provider names</h2>" + EOL);
            ArrayList<String> expectedProvidersNameLocal = this.getKnownProviderNames();
            int i = 0;
            while (i < expectedProvidersNameLocal.size()) {
                this.println((FileWriter)outfileWriter, String.valueOf(expectedProvidersNameLocal.get(i)) + EOL);
                ++i;
            }
            boolean bl = incorrectProviderName.size() > 0;
            return bl;
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean testProviderNames() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUs();
        return this.checkProviderNames(allIUs);
    }

    private boolean inListOfExpectedName(String providerName) {
        ArrayList<String> expectedProvidersNameLocal = this.getKnownProviderNames();
        boolean result = false;
        if (expectedProvidersNameLocal != null) {
            int i = 0;
            while (i < expectedProvidersNameLocal.size()) {
                if (expectedProvidersNameLocal.get(i).equals(providerName)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private void printLinesProvider(FileWriter out, List<IInstallableUnit> iuList) throws IOException {
        IUIdComparator comparatorProviderName = new IUIdComparator();
        Collections.sort(iuList, comparatorProviderName);
        out.write("<p>Count: " + iuList.size() + EOL);
        out.write("<ol>" + EOL);
        for (IInstallableUnit iu : iuList) {
            this.printLineListItem(out, iu, "org.eclipse.equinox.p2.provider");
        }
        out.write("</ol>" + EOL);
    }

    protected ArrayList<String> getKnownProviderNames() {
        if (this.expectedProvidersName == null) {
            ArrayList<String> namesAsList = new ArrayList<String>();
            String expectedProviders = System.getProperty(EXPECTED_PROVIDER_NAMES_KEY);
            if (expectedProviders == null) {
                Properties names = new Properties();
                InputStream inStream = null;
                try {
                    inStream = this.getClass().getResourceAsStream(KNOWN_PROVIDERS_RESOURCE);
                    try {
                        names.load(inStream);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    expectedProviders = names.getProperty(EXPECTED_PROVIDER_NAMES_KEY);
                    if (expectedProviders == null) {
                        throw new Error("PROGRAM ERROR: Could not read internal property file");
                    }
                    StringTokenizer tokenizer = new StringTokenizer(expectedProviders, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        String name = tokenizer.nextToken();
                        namesAsList.add(name.trim());
                    }
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.expectedProvidersName = namesAsList;
            }
        }
        return this.expectedProvidersName;
    }
}

