/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class TestProperties {
    private static final String KNOWN_PROVIDERS_RESOURCE = "knownProviders.properties";
    private static final String EXPECTED_PROVIDER_NAMES_KEY = "expectedProviderNames";
    private ArrayList<String> EXPECTED_PROVIDER_NAMES = null;

    public static void main(String[] args) {
        try {
            ArrayList<String> testnames = new TestProperties().getKnownProviderNames();
            int i = 0;
            while (i < testnames.size()) {
                System.out.println(testnames.get(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getKnownProviderNames() throws Exception {
        if (this.EXPECTED_PROVIDER_NAMES == null) {
            ArrayList<String> namesAsList = new ArrayList<String>();
            String expectedProviders = System.getProperty(EXPECTED_PROVIDER_NAMES_KEY);
            if (expectedProviders == null) {
                Properties names = new Properties();
                try (InputStream inStream = null;){
                    inStream = this.getClass().getResourceAsStream(KNOWN_PROVIDERS_RESOURCE);
                    names.load(inStream);
                    expectedProviders = names.getProperty(EXPECTED_PROVIDER_NAMES_KEY);
                    if (expectedProviders == null) {
                        throw new Exception("PROGRAM ERROR: Could not read internal property file");
                    }
                    StringTokenizer tokenizer = new StringTokenizer(expectedProviders, ",", false);
                    while (tokenizer.hasMoreTokens()) {
                        String name = tokenizer.nextToken();
                        namesAsList.add(name.trim());
                    }
                }
                this.EXPECTED_PROVIDER_NAMES = namesAsList;
            }
        }
        return this.EXPECTED_PROVIDER_NAMES;
    }
}

