/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.analyzers.BuildRepoTests;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.TestActivator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;

public class TestRepo
extends BuildRepoTests {
    protected static final boolean DEBUG = false;
    protected static final String EOL = System.getProperty("line.separator", "\n");
    protected static final String NBSP = " &nbsp; ";
    protected static final String BR = "<br/>" + EOL;
    private IQueryResult<IInstallableUnit> allCurrentIUs;
    private IQueryResult<IInstallableUnit> allReferenceIUs;
    private String repoURLToTest;
    private String repoURLForReference;

    public TestRepo(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    protected void println(FileWriter out, String wholeLine) throws IOException {
        out.write("<li>" + wholeLine + "</li>" + EOL);
    }

    protected void printRowln(FileWriter out, String wholeLine) throws IOException {
        out.write("<tr>" + wholeLine + "</tr>" + EOL);
    }

    protected void printStartTable(FileWriter out, String attributes) throws IOException {
        String attributeString = attributes;
        if (attributeString == null) {
            attributeString = "";
        }
        out.write("<table " + attributeString + ">" + EOL);
    }

    protected void printEndTable(FileWriter out) throws IOException {
        out.write("</table>" + EOL);
    }

    protected void printparagraph(FileWriter out, String wholeLine) throws IOException {
        out.write("<p>" + this.convertEOLtoBR(wholeLine) + "</p>" + EOL);
    }

    protected void printHeader(FileWriter out, int level, String wholeLine) throws IOException {
        out.write("<h" + level + ">" + wholeLine + "</h" + level + ">" + EOL);
    }

    private String convertEOLtoBR(String wholeLine) {
        String result = wholeLine;
        result = result.replaceAll("\\r\\n", "<br />\n");
        result = result.replaceAll("\\n", "<br />\n");
        result = result.replaceAll("\\r", "<br />\n");
        return result;
    }

    protected boolean isSpecial(IInstallableUnit iu) {
        String iuId = iu.getId();
        boolean isSpecial = iuId.startsWith("a.jre") || iuId.startsWith("config.a.jre") || iuId.endsWith("_root") || iuId.contains(".executable.") || iuId.contains("configuration_root") || iuId.contains("executable_root") || iuId.startsWith("toolingorg.eclipse") || iuId.startsWith("tooling.");
        return isSpecial;
    }

    protected boolean isEclipseLicenseIU(IInstallableUnit iu) {
        return "org.eclipse.license.feature.group".equals(iu.getId()) || "org.eclipse.license.feature.jar".equals(iu.getId());
    }

    protected boolean isFeatureGroup(IInstallableUnit iu) {
        String iuId = iu.getId();
        boolean isFeatureGroup = iuId.endsWith("feature.group");
        return isFeatureGroup;
    }

    protected boolean isGroup(IInstallableUnit iu) {
        boolean isGroup = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.group"));
        return isGroup;
    }

    protected void printLineListItem(FileWriter outfileWriter, IInstallableUnit iu, String iuproperty) throws IOException {
        String iupropertyValue = iu.getProperty(iuproperty, null);
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        this.println(outfileWriter, String.valueOf(iuId) + NBSP + iuVersion + NBSP + BR + iupropertyValue);
    }

    protected void printLineListItem(FileWriter outfileWriter, IInstallableUnit iu, IInstallableUnit iuRef) throws IOException {
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        String iuRefVersion = iuRef.getVersion().toString();
        int diff = iuVersion.compareTo(iuRefVersion);
        this.println(outfileWriter, String.valueOf(diff) + NBSP + iuId + NBSP + iuRefVersion + NBSP + iuVersion);
    }

    protected void printLineRowItem(FileWriter outfileWriter, IInstallableUnit iu, IInstallableUnit iuRef) throws IOException {
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        String iuRefVersion = iuRef.getVersion().toString();
        this.printRowln(outfileWriter, "<td>" + iuId + "</td><td>" + iuRefVersion + "</td><td>" + iuVersion + "</td>");
    }

    protected void printLineListItem(FileWriter outfileWriter, String string) throws IOException {
        this.println(outfileWriter, string);
    }

    protected void printAllProperties(FileWriter outFileWriter, IInstallableUnit iu) throws IOException {
        Map properties = iu.getProperties();
        Set keys = properties.keySet();
        for (Object key : keys) {
            String value = (String)properties.get(key);
            this.println(outFileWriter, key + " : " + value);
        }
    }

    protected IQueryResult<IInstallableUnit> getAllReferenceIUs() throws URISyntaxException, ProvisionException {
        String repoRefURL;
        if (this.allReferenceIUs == null && (repoRefURL = this.getRepoURLForReference()).length() > 0) {
            this.allReferenceIUs = this.getAllIUscore(repoRefURL);
        }
        return this.allReferenceIUs;
    }

    protected IQueryResult<IInstallableUnit> getAllIUs() throws URISyntaxException, ProvisionException {
        if (this.allCurrentIUs == null) {
            String repoURL = this.getRepoURLToTest();
            this.allCurrentIUs = this.getAllIUscore(repoURL);
        }
        return this.allCurrentIUs;
    }

    private IQueryResult<IInstallableUnit> getAllIUscore(String repoURL) throws URISyntaxException, ProvisionException {
        IQueryResult allIUs = null;
        URI repoLocation = null;
        try {
            repoLocation = new URI(repoURL);
            IMetadataRepositoryManager repomgr = TestRepo.getMetadataRepositoryManager();
            if (repomgr != null) {
                IMetadataRepository repo = repomgr.loadRepository(repoLocation, null);
                if (repo == null) {
                    this.handleFatalError("no repository found at " + repoLocation.toString());
                } else {
                    allIUs = repo.query(QueryUtil.createIUAnyQuery(), null);
                    if (allIUs.isEmpty()) {
                        this.handleFatalError("no IUs in repository" + repoLocation.toString());
                    }
                }
            } else {
                System.out.println("Could not getMetadataRepositoryManager");
            }
        }
        catch (ProvisionException e) {
            System.out.println("repoURL: " + repoURL);
            System.out.println("repoLocation:" + repoLocation);
            throw e;
        }
        return allIUs;
    }

    protected IQueryResult<IInstallableUnit> getAllGroupIUs() throws URISyntaxException, ProvisionException {
        String repoURL = this.getRepoURLToTest();
        return this.getAllGroupIUscore(repoURL);
    }

    protected IQueryResult<IInstallableUnit> getAllReferenceGroupIUs() throws URISyntaxException, ProvisionException {
        IQueryResult<IInstallableUnit> result = null;
        String repoURL = this.getRepoURLForReference();
        if (repoURL.length() > 0) {
            result = this.getAllGroupIUscore(repoURL);
        }
        return result;
    }

    private IQueryResult<IInstallableUnit> getAllGroupIUscore(String repoURL) throws URISyntaxException, ProvisionException {
        IQueryResult allIUs = null;
        URI repoLocation = new URI(repoURL);
        IMetadataRepositoryManager repositoryManager = TestRepo.getMetadataRepositoryManager();
        if (repositoryManager == null) {
            this.handleFatalError("IMetadataRepositoryManager service is not registered.");
            return null;
        }
        IMetadataRepository repo = repositoryManager.loadRepository(repoLocation, null);
        if (repo == null) {
            this.handleFatalError("no repository found at " + repoLocation.toString());
        } else {
            allIUs = repo.query(QueryUtil.createIUGroupQuery(), null);
            if (allIUs.isEmpty()) {
                this.handleFatalError("no IUs in repository " + repoLocation.toString());
            }
        }
        return allIUs;
    }

    protected static IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)TestRepo.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    protected static IProvisioningAgent getAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
    }

    public String getRepoURLToTest() {
        if (this.repoURLToTest == null) {
            this.repoURLToTest = this.getConfigurations().getRepoURLToTest();
            if (this.repoURLToTest == null) {
                this.handleFatalError("the 'repoURLToTest' property was not set");
            }
        }
        return this.repoURLToTest;
    }

    public String getRepoURLForReference() {
        if (this.repoURLForReference == null) {
            this.repoURLForReference = this.getConfigurations().getRepoURLForReference();
            if (this.repoURLForReference == null) {
                this.handleWarning("the 'repoURLForReference' property was not set");
                this.repoURLForReference = "";
            }
            if (this.repoURLForReference.length() > 0) {
                System.out.println("repoURLForReference: " + this.repoURLForReference);
            }
        }
        return this.repoURLForReference;
    }

    public void setRepoURLToTest(String repoURLToTest) {
        this.repoURLToTest = repoURLToTest;
    }

    public void setRepoURLForReference(String repoURLForReference) {
        this.repoURLForReference = repoURLForReference;
    }

    protected boolean isCategory(IInstallableUnit curiu) {
        boolean isCategory = "true".equals(curiu.getProperty("org.eclipse.equinox.p2.type.category"));
        return isCategory;
    }
}

