/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.repos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.analyzers.RepoTestsConfiguration;
import org.eclipse.cbi.p2repo.analyzers.repos.TestRepo;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;

public class VersionChecking
extends TestRepo {
    private static final String EQUALS = "equals";
    private static final String STARTS_WITH = "startsWith";
    private static final int STARTWITH_MATCH_LENGTH = 5;

    public VersionChecking(RepoTestsConfiguration configurations) {
        super(configurations);
    }

    public boolean testVersionUniqness() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUs();
        if (allIUs == null) {
            return true;
        }
        this.analyzeVersionPatterns(allIUs);
        return this.analyzeNonUniqueVersions(allIUs);
    }

    private void analyzeVersionPatterns(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(String.valueOf(testDirName) + "/" + "versionPatterns.txt");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            outfileWriter.write("Version qualifer patterns used in repository" + EOL + EOL);
            outfileWriter.write("Repository ('repoURLToTest'): " + this.getRepoURLToTest() + EOL + EOL);
            outfileWriter.write("(Exploratory report ... maybe eventually used to find typos, such as 'qualfer')" + EOL + EOL);
            List<String> allQualifiers = this.collectQualifiers(allIUs, (FileWriter)outfileWriter);
            this.collapseSortedQualifiers((FileWriter)outfileWriter, allQualifiers);
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void collapseSortedQualifiers(FileWriter outfileWriter, List<String> allQualifiers) throws IOException, Error {
        String reference = null;
        int refCount = 0;
        String type = EQUALS;
        Collections.sort(allQualifiers);
        outfileWriter.write(String.valueOf(EOL) + "Count of (sorted) patterns matching up to " + 5 + " characters." + EOL + EOL);
        for (String q : allQualifiers) {
            if (reference == null) {
                reference = q;
                refCount = 1;
                continue;
            }
            if (reference.equals(q)) {
                ++refCount;
                type = EQUALS;
                continue;
            }
            if (reference.length() == 0) {
                reference = "[empty string]";
                outfileWriter.write(String.valueOf(refCount) + "\t" + type + "\t\t\t" + reference + EOL);
                reference = q;
                refCount = 1;
                type = EQUALS;
                continue;
            }
            if (this.startsSimilar(reference, q)) {
                ++refCount;
                type = STARTS_WITH;
                continue;
            }
            if (STARTS_WITH.equals(type)) {
                outfileWriter.write(String.valueOf(refCount) + "\t" + type + "\t\t" + this.subsection(reference) + EOL);
            } else if (EQUALS.equals(type)) {
                outfileWriter.write(String.valueOf(refCount) + "\t" + type + "\t\t\t" + reference + EOL);
            } else {
                throw new Error();
            }
            reference = q;
            refCount = 1;
            type = EQUALS;
        }
    }

    private List<String> collectQualifiers(IQueryResult<IInstallableUnit> allIUs, FileWriter outfileWriter) throws IOException, Error {
        ArrayList<String> allQualifiers = new ArrayList<String>();
        int nonOSGiCompatible = 0;
        int nLessThanFour = 0;
        int nMoreThanFour = 0;
        for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
            boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
            if (isCategory || this.isSpecial(iu)) continue;
            Version bundleVersion = iu.getVersion();
            if (bundleVersion.isOSGiCompatible()) {
                if (bundleVersion.getSegmentCount() == 4) {
                    Comparable qualifier = bundleVersion.getSegment(3);
                    if (qualifier instanceof String) {
                        String qString = (String)((Object)qualifier);
                        if (qString.length() == 0) {
                            outfileWriter.write("zero length 4th segment: " + iu.getId() + EOL);
                        }
                        allQualifiers.add(qString);
                        continue;
                    }
                    throw new Error("Program Error");
                }
                if (bundleVersion.getSegmentCount() < 4) {
                    ++nLessThanFour;
                    continue;
                }
                if (bundleVersion.getSegmentCount() <= 4) continue;
                ++nMoreThanFour;
                continue;
            }
            ++nonOSGiCompatible;
        }
        outfileWriter.write(String.valueOf(EOL) + "Number of nonOSGi compatible versions: " + nonOSGiCompatible + EOL);
        outfileWriter.write(String.valueOf(EOL) + "Number with more than 4 segments: " + nMoreThanFour + EOL);
        outfileWriter.write(String.valueOf(EOL) + "Number wtih less than 4 segments: " + nLessThanFour + EOL + EOL);
        return allQualifiers;
    }

    private boolean startsSimilar(String reference, String q) {
        return q.startsWith(this.subsection(reference));
    }

    private String subsection(String reference) {
        String result = reference;
        if (reference.length() >= 5) {
            result = reference.substring(0, 5);
        }
        return result;
    }

    private boolean analyzeNonUniqueVersions(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        Map bundles = this.tabulateNonUniqueIDs(allIUs);
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        String testDirName = this.getReportOutputDirectory();
        try {
            outfile = new File(testDirName, "nonUniqueVersions.txt");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            outfileWriter.write("Non Unique Versions used in repository" + EOL + EOL);
            outfileWriter.write("Repository ('repoURLToTest'): " + this.getRepoURLToTest() + EOL + EOL);
            int nUnique = 0;
            for (Object bundleId : bundles.keySet()) {
                Set versionSet = (Set)bundles.get(bundleId);
                if (versionSet.size() == 1) {
                    ++nUnique;
                    continue;
                }
                this.printId((FileWriter)outfileWriter, bundleId);
                for (Object version : versionSet) {
                    this.printVersion((FileWriter)outfileWriter, version);
                }
            }
            outfileWriter.write(String.valueOf(EOL) + "Number of unique id-versions " + nUnique + EOL);
            return false;
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Map tabulateNonUniqueIDs(IQueryResult<IInstallableUnit> allIUs) {
        HashMap bundles = new HashMap();
        for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
            try {
                Set<Version> versionSet;
                boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
                if (isCategory) continue;
                String bundleId = iu.getId();
                Version bundleVersion = iu.getVersion();
                if (bundles.containsKey(bundleId)) {
                    versionSet = (Set)bundles.get(bundleId);
                    versionSet.add(bundleVersion);
                    continue;
                }
                versionSet = new HashSet();
                versionSet.add(bundleVersion);
                bundles.put(bundleId, versionSet);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return bundles;
    }

    private void printId(FileWriter out, Object id) throws IOException {
        out.write(id + EOL);
    }

    private void printVersion(FileWriter out, Object version) throws IOException {
        out.write("\t" + version + EOL);
    }
}

