/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class BundleJarUtils {
    public static File unpack200gz(File fileToUnpack) throws IOException {
        GZIPInputStream input = new GZIPInputStream(new FileInputStream(fileToUnpack));
        File unpacked = File.createTempFile("unpacked_" + fileToUnpack.getName() + "_", ".jar");
        unpacked.deleteOnExit();
        FileOutputStream outStream = new FileOutputStream(unpacked);
        JarOutputStream jarOutStream = new JarOutputStream(outStream);
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        unpacker.unpack((InputStream)input, jarOutStream);
        jarOutStream.close();
        return unpacked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getJarManifestEntry(InputStream input, String key) {
        String manifestEntry = null;
        try {
            try {
                Map attributes = ManifestElement.parseBundleManifest((InputStream)input, null);
                manifestEntry = (String)attributes.get(key);
                return manifestEntry;
            }
            catch (BundleException e) {
                e.printStackTrace();
                if (input == null) return manifestEntry;
                try {
                    input.close();
                    return manifestEntry;
                }
                catch (IOException iOException) {}
                return manifestEntry;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (input == null) return manifestEntry;
                try {
                    input.close();
                    return manifestEntry;
                }
                catch (IOException iOException) {}
                return manifestEntry;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getJarManifestEntry(File file, String key) {
        String string;
        InputStream input = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file, false, 1);
            JarEntry entry = jar.getJarEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                return null;
            }
            input = jar.getInputStream(entry);
            string = BundleJarUtils.getJarManifestEntry(input, key);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getEclipseInf(File jarfile) {
        ZipFile jar = null;
        Properties properties = new Properties();
        try {
            try {
                jar = new JarFile(jarfile, false, 1);
                JarEntry eclipseInf = ((JarFile)jar).getJarEntry("META-INF/eclipse.inf");
                if (eclipseInf == null) return properties;
                properties.load(((JarFile)jar).getInputStream(eclipseInf));
                return properties;
            }
            catch (ZipException e) {
                System.out.println("Failed to open jar file (zip exception): " + jarfile.getAbsolutePath());
                if (jar == null) return properties;
                try {
                    jar.close();
                    return properties;
                }
                catch (IOException iOException) {}
                return properties;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (jar == null) return properties;
                try {
                    jar.close();
                    return properties;
                }
                catch (IOException iOException) {}
                return properties;
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

