/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.utils;

import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class ReportWriter {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private String outputFilename;
    private PrintWriter outfilewriter;

    public ReportWriter(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public void writeln(String text) throws FileNotFoundException {
        this.getOutfilewriter().write(String.valueOf(text) + EOL);
    }

    public void writeln() throws FileNotFoundException {
        this.getOutfilewriter().write(EOL);
    }

    public void close() throws FileNotFoundException {
        if (this.getOutfilewriter() != null) {
            this.getOutfilewriter().close();
        }
    }

    public void writeln(Object object) throws FileNotFoundException {
        this.writeln(object.toString());
    }

    public void printf(String format, Object ... args) throws FileNotFoundException {
        this.getOutfilewriter().printf(format, args);
    }

    private PrintWriter getOutfilewriter() throws FileNotFoundException {
        if (this.outfilewriter == null) {
            this.outfilewriter = new PrintWriter(this.getOutputFilename());
        }
        return this.outfilewriter;
    }
}

