/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.analyzers.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.jarprocessor.StreamProcessor;
import org.eclipse.equinox.internal.p2.jarprocessor.Utils;

public class VerifyStep {
    private static final String JAR_VERIFIED = "jar verified.";
    static String verifyCommand = "jarsigner";
    static Boolean canVerify = null;

    public static boolean canVerify() {
        if (canVerify != null) {
            return canVerify;
        }
        String javaHome = System.getProperty("java.home");
        String command = String.valueOf(javaHome) + "/../bin/jarsigner";
        int result = VerifyStep.execute(new String[]{command}, false);
        if (result < 0) {
            command = "jarsigner";
            result = VerifyStep.execute(new String[]{command}, false);
            if (result < 0) {
                canVerify = Boolean.FALSE;
                return false;
            }
        }
        verifyCommand = command;
        canVerify = Boolean.TRUE;
        return true;
    }

    public String getStepName() {
        return "Verify";
    }

    public File postProcess(File input, File workingDirectory, List<Properties> containers) {
        return null;
    }

    public static boolean verify(File input, StringBuilder errors, StringBuilder warnings) {
        if (VerifyStep.canVerify() && verifyCommand != null) {
            block8: {
                Process resultProc;
                block7: {
                    String[] cmd = new String[]{verifyCommand, "-verify", input.getCanonicalPath()};
                    ProcessBuilder procBuilder = new ProcessBuilder(cmd);
                    procBuilder.redirectErrorStream(true);
                    resultProc = procBuilder.start();
                    int result = resultProc.waitFor();
                    if (result == 0) break block7;
                    errors.append("Error: " + result + " was returned from command: " + Utils.concat((String[])cmd));
                    return false;
                }
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resultProc.getInputStream()));
                    StringBuilder out = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("Picked up JAVA_TOOL_OPTIONS")) continue;
                        out.append(line);
                    }
                    reader.close();
                    String outString = out.toString();
                    if (outString.contains(JAR_VERIFIED)) break block8;
                    if (outString.contains("Warning:")) {
                        warnings.append(outString);
                        break block8;
                    }
                    errors.append((CharSequence)out);
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected static int execute(String[] cmd, boolean verbose) {
        Runtime runtime = Runtime.getRuntime();
        Process proc = null;
        try {
            proc = runtime.exec(cmd);
            StreamProcessor.start((InputStream)proc.getInputStream(), (String)"STDOUT", (boolean)verbose);
        }
        catch (Exception e) {
            if (verbose) {
                System.out.println("Error executing command " + Utils.concat((String[])cmd));
                e.printStackTrace();
            }
            return -1;
        }
        try {
            int result = proc.waitFor();
            return result;
        }
        catch (InterruptedException e) {
            if (verbose) {
                e.printStackTrace();
            }
            return -1;
        }
    }
}

