/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.utils.password;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestBase {
    private final MessageDigest digest;
    private final Charset passwordCharset;

    public DigestBase(String algorithm, String passwordCharsetEncoder) {
        this.passwordCharset = Charset.forName(passwordCharsetEncoder);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.digest = digest;
    }

    protected byte[] makeDigest(String providedPassword) throws NoSuchAlgorithmException {
        if (this.digest == null) {
            throw new NoSuchAlgorithmException();
        }
        ByteBuffer data = this.passwordCharset.encode(providedPassword);
        this.digest.update(data.array(), 0, data.remaining());
        return this.digest.digest();
    }
}

