/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.storage.AbstractStorage;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.str.StringReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl
extends AbstractStorage {
    private static final int SPLIT_PATH_DEPTH = 2;
    private static final Logger logger = LoggerFactory.getLogger(StorageImpl.class);
    private final File rootFolder;
    private final ExecutorService executorService = new ExportedExecutorService(StorageImpl.class.getName(), 1, 1, 0L, TimeUnit.MILLISECONDS);

    public StorageImpl() throws IOException {
        this.rootFolder = new File(StorageImpl.getRootFolder());
        if (!this.rootFolder.exists()) {
            this.rootFolder.mkdirs();
        }
        if (!this.rootFolder.exists() || !this.rootFolder.isDirectory()) {
            throw new IOException(String.format("Unable to use directory: %s", this.rootFolder));
        }
    }

    private static String getRootFolder() {
        String str = System.getProperty("org.eclipse.scada.ds.storage.file.root", "${user.home}" + File.separator + "scadaDS");
        return StringReplacer.replace((String)str, (Map)System.getProperties());
    }

    protected Executor getExecutor() {
        return this.executorService;
    }

    public synchronized void dispose() {
        super.dispose();
        this.executorService.shutdown();
    }

    public synchronized NotifyFuture<DataNode> readNode(String nodeId) {
        try {
            return new InstantFuture((Object)this.loadFile(nodeId));
        }
        catch (Exception e) {
            logger.warn("Failed to load data node", (Throwable)e);
            return new InstantErrorFuture((Throwable)e);
        }
    }

    private DataNode loadFile(String nodeId) throws IOException {
        File file = this.makeFile(nodeId);
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            DataNode dataNode = new DataNode(nodeId, (InputStream)stream);
            return dataNode;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private File makeFile(String nodeId) {
        String hash = String.format("%08X", nodeId.hashCode());
        File root = this.rootFolder;
        int i = 1;
        while (i <= 2) {
            root = new File(root, hash.substring(0, i));
            ++i;
        }
        try {
            return new File(root, URLEncoder.encode(nodeId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new File(root, nodeId.replaceAll("[^a-zA-Z0-9]", "_"));
        }
    }

    public synchronized NotifyFuture<Void> writeNode(DataNode node) {
        File file = this.makeFile(node.getId());
        try {
            this.saveTo(node, file);
            this.fireUpdate(node);
            return new InstantFuture(null);
        }
        catch (IOException e) {
            logger.warn("Failed to store data node", (Throwable)e);
            return new InstantErrorFuture((Throwable)e);
        }
    }

    private void saveTo(DataNode node, File file) throws IOException {
        file.delete();
        byte[] data = node.getData();
        if (data == null) {
            return;
        }
        file.getParentFile().mkdirs();
        FileOutputStream stream = new FileOutputStream(file);
        try {
            stream.write(node.getData());
        }
        finally {
            stream.close();
        }
    }

    public synchronized NotifyFuture<Void> deleteNode(String nodeId) {
        File file = this.makeFile(nodeId);
        file.delete();
        return new InstantFuture(null);
    }
}

