/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.EmptySeq;
import com.codepoetics.protonpack.PairSeq;
import com.codepoetics.protonpack.StreamUtils;
import com.codepoetics.protonpack.Streamable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface Seq<T>
extends Streamable<T> {
    public static <T> Seq<T> empty() {
        return new EmptySeq();
    }

    public static <T> Seq<T> singleton(T item) {
        return new PairSeq<T>(item, Seq.empty());
    }

    public static <T> Seq<T> of(T ... items) {
        return Seq.of(Stream.of(items)).reverse();
    }

    public static <T> Seq<T> of(List<T> list) {
        return Seq.of(list.stream()).reverse();
    }

    public static <T> Seq<T> of(Collection<T> collection) {
        return Seq.of(collection.stream());
    }

    public static <T> Seq<T> of(Stream<T> stream) {
        return stream.reduce(Seq.empty(), Seq::cons, Seq::append);
    }

    default public Seq<T> reverse() {
        return Seq.of(this.stream());
    }

    public T head();

    public Seq<T> tail();

    public Seq<T> cons(T var1);

    default public Seq<T> append(Seq<T> items) {
        return this.concat(items).toSeq().reverse();
    }

    public boolean isEmpty();

    @Override
    default public Stream<T> get() {
        return this.isEmpty() ? Stream.empty() : StreamUtils.unfold(this, s -> s.tail().isEmpty() ? Optional.empty() : Optional.of(s.tail())).map(Seq::head);
    }

    @Override
    default public Seq<T> toSeq() {
        return this;
    }
}

