/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.injector.internal;

import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ae.server.injector.internal.EventInjectorManager;
import org.eclipse.scada.ae.server.injector.monitor.EventMonitorFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private EventInjectorManager manager;
    private ExecutorService executor;
    private EventMonitorFactory factory;
    private ServiceRegistration<?> factoryServiceHandle;
    private ObjectPoolImpl<MonitorService> monitorServicePool;
    private ServiceRegistration<?> monitorServicePoolHandler;
    private EventProcessor eventProcessor;

    public void start(BundleContext context) throws Exception {
        this.eventProcessor = new EventProcessor(context);
        this.eventProcessor.open();
        this.monitorServicePool = new ObjectPoolImpl();
        this.monitorServicePoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.monitorServicePool, MonitorService.class);
        this.executor = ExportedExecutorService.newSingleThreadExportedExecutor((String)(String.valueOf(context.getBundle().getSymbolicName()) + "/" + context.getBundle().getBundleId()));
        this.factory = new EventMonitorFactory(context, this.executor, this.monitorServicePool, this.eventProcessor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("factoryId", "ae.monitor.ae.event.external");
        properties.put("service.description", "Filter based event monitor");
        this.factoryServiceHandle = context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)this.factory, properties);
        if (this.manager == null) {
            this.manager = new EventInjectorManager(this.factory);
            this.manager.start();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.manager != null) {
            this.manager.stop();
            this.manager = null;
        }
        if (this.factoryServiceHandle != null) {
            this.factoryServiceHandle.unregister();
            this.factoryServiceHandle = null;
        }
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        this.monitorServicePoolHandler.unregister();
        this.monitorServicePool.dispose();
        this.eventProcessor.close();
        this.executor.shutdown();
        this.executor = null;
    }
}

