/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.common.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.ca.common.factory.Service;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractServiceFactory
implements ConfigurationFactory {
    private final Map<String, Service> instances = new HashMap<String, Service>();
    private final Map<String, ServiceRegistration<?>> regs = new HashMap();
    private final BundleContext context;

    public AbstractServiceFactory(BundleContext context) {
        this.context = context;
    }

    public synchronized void dispose() {
        for (ServiceRegistration<?> reg : this.regs.values()) {
            reg.unregister();
        }
        for (Service service : this.instances.values()) {
            service.dispose();
        }
        this.instances.clear();
        this.regs.clear();
    }

    public synchronized void delete(UserInformation information, String configurationId) throws Exception {
        Service service;
        ServiceRegistration<?> reg = this.regs.remove(configurationId);
        if (reg != null) {
            reg.unregister();
        }
        if ((service = this.instances.remove(configurationId)) != null) {
            service.dispose();
        }
    }

    public synchronized void update(UserInformation information, String configurationId, Map<String, String> properties) throws Exception {
        Service service = this.instances.get(configurationId);
        if (service != null) {
            service.update(information, properties);
        } else {
            Service newService = this.createService(information, configurationId, properties);
            if (newService != null) {
                ServiceRegistration<?> reg = this.registerService(information, this.context, configurationId, newService);
                if (reg != null) {
                    this.regs.put(configurationId, reg);
                    this.instances.put(configurationId, newService);
                } else {
                    newService.dispose();
                }
            }
        }
    }

    protected abstract Service createService(UserInformation var1, String var2, Map<String, String> var3) throws Exception;

    protected abstract ServiceRegistration<?> registerService(UserInformation var1, BundleContext var2, String var3, Service var4);
}

