/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.common.factory;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.lang.Disposable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfigurationFactory
extends AbstractServiceConfigurationFactory<BeanServiceInstance> {
    private static final Logger logger = LoggerFactory.getLogger(BeanConfigurationFactory.class);
    private final Class<?> beanClazz;
    private final boolean mergeIdField;

    public BeanConfigurationFactory(BundleContext context, Class<?> beanClazz, boolean mergeIdField) {
        super(context);
        this.beanClazz = beanClazz;
        this.mergeIdField = true;
    }

    public BeanConfigurationFactory(BundleContext context, Class<?> beanClazz) {
        this(context, beanClazz, true);
    }

    @Override
    protected AbstractServiceConfigurationFactory.Entry<BeanServiceInstance> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        BeanServiceInstance bean = new BeanServiceInstance(this.beanClazz.newInstance());
        if (this.mergeIdField) {
            parameters.put("id", configurationId);
        }
        bean.update(parameters);
        ServiceRegistration reg = context.registerService(this.beanClazz.getName(), bean.getTargetBean(), bean.getProperties());
        return new AbstractServiceConfigurationFactory.Entry<BeanServiceInstance>(configurationId, bean, reg);
    }

    @Override
    protected void disposeService(UserInformation userInformation, String id, BeanServiceInstance service) {
        if (service instanceof Disposable) {
            ((Disposable)service).dispose();
        }
    }

    @Override
    protected AbstractServiceConfigurationFactory.Entry<BeanServiceInstance> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<BeanServiceInstance> entry, Map<String, String> parameters) throws Exception {
        entry.getService().update(parameters);
        entry.getHandle().setProperties(entry.getService().getProperties());
        return null;
    }

    protected static class BeanServiceInstance {
        private final Object targetBean;

        public Object getTargetBean() {
            return this.targetBean;
        }

        public Dictionary<String, ?> getProperties() {
            try {
                Hashtable result = new Hashtable();
                Map properties = new BeanUtilsBean2().describe(this.targetBean);
                for (Map.Entry entry : properties.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ((Dictionary)result).put(entry.getKey().toString(), entry.getValue());
                }
                return result;
            }
            catch (Exception e) {
                logger.warn("Failed to get dictionary", (Throwable)e);
                return new Hashtable(1);
            }
        }

        public BeanServiceInstance(Object targetBean) {
            this.targetBean = targetBean;
        }

        public void update(Map<String, String> parameters) throws Exception {
            new BeanUtilsBean2().populate(this.targetBean, parameters);
        }
    }
}

