/*******************************************************************************
 * Copyright (c) 2013, 2014 IBH SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBH SYSTEMS GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.scada.configuration.world.osgi.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;
import org.eclipse.scada.configuration.world.osgi.util.OsgiAdapterFactory;
import org.eclipse.scada.configuration.world.provider.WorldEditPlugin;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class OsgiItemProviderAdapterFactory extends OsgiAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender
{
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This helps manage the child creation extenders.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager ( WorldEditPlugin.INSTANCE, OsgiPackage.eNS_URI );

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public OsgiItemProviderAdapterFactory ()
    {
        supportedTypes.add ( IEditingDomainItemProvider.class );
        supportedTypes.add ( IStructuredItemContentProvider.class );
        supportedTypes.add ( ITreeItemContentProvider.class );
        supportedTypes.add ( IItemLabelProvider.class );
        supportedTypes.add ( IItemPropertySource.class );
        supportedTypes.add ( ITableItemLabelProvider.class );
        supportedTypes.add ( IItemStyledLabelProvider.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DataAccessConnection} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataAccessConnectionItemProvider dataAccessConnectionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DataAccessConnection}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataAccessConnectionAdapter ()
    {
        if ( dataAccessConnectionItemProvider == null )
        {
            dataAccessConnectionItemProvider = new DataAccessConnectionItemProvider ( this );
        }

        return dataAccessConnectionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DataAccessExporter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataAccessExporterItemProvider dataAccessExporterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DataAccessExporter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataAccessExporterAdapter ()
    {
        if ( dataAccessExporterItemProvider == null )
        {
            dataAccessExporterItemProvider = new DataAccessExporterItemProvider ( this );
        }

        return dataAccessExporterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.SourceItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SourceItemItemProvider sourceItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.SourceItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSourceItemAdapter ()
    {
        if ( sourceItemItemProvider == null )
        {
            sourceItemItemProvider = new SourceItemItemProvider ( this );
        }

        return sourceItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ItemExport} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemExportItemProvider itemExportItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ItemExport}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemExportAdapter ()
    {
        if ( itemExportItemProvider == null )
        {
            itemExportItemProvider = new ItemExportItemProvider ( this );
        }

        return itemExportItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ItemInformation} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemInformationItemProvider itemInformationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ItemInformation}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemInformationAdapter ()
    {
        if ( itemInformationItemProvider == null )
        {
            itemInformationItemProvider = new ItemInformationItemProvider ( this );
        }

        return itemInformationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.LevelMonitor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected LevelMonitorItemProvider levelMonitorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.LevelMonitor}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createLevelMonitorAdapter ()
    {
        if ( levelMonitorItemProvider == null )
        {
            levelMonitorItemProvider = new LevelMonitorItemProvider ( this );
        }

        return levelMonitorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ScriptItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScriptItemItemProvider scriptItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ScriptItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScriptItemAdapter ()
    {
        if ( scriptItemItemProvider == null )
        {
            scriptItemItemProvider = new ScriptItemItemProvider ( this );
        }

        return scriptItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ImportItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ImportItemItemProvider importItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ImportItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createImportItemAdapter ()
    {
        if ( importItemItemProvider == null )
        {
            importItemItemProvider = new ImportItemItemProvider ( this );
        }

        return importItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.SummaryGroup} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SummaryGroupItemProvider summaryGroupItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.SummaryGroup}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSummaryGroupAdapter ()
    {
        if ( summaryGroupItemProvider == null )
        {
            summaryGroupItemProvider = new SummaryGroupItemProvider ( this );
        }

        return summaryGroupItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MarkerGroup} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MarkerGroupItemProvider markerGroupItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MarkerGroup}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMarkerGroupAdapter ()
    {
        if ( markerGroupItemProvider == null )
        {
            markerGroupItemProvider = new MarkerGroupItemProvider ( this );
        }

        return markerGroupItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Markers} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MarkersItemProvider markersItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Markers}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMarkersAdapter ()
    {
        if ( markersItemProvider == null )
        {
            markersItemProvider = new MarkersItemProvider ( this );
        }

        return markersItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ConstantItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConstantItemItemProvider constantItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ConstantItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConstantItemAdapter ()
    {
        if ( constantItemItemProvider == null )
        {
            constantItemItemProvider = new ConstantItemItemProvider ( this );
        }

        return constantItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.SummaryItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SummaryItemItemProvider summaryItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.SummaryItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSummaryItemAdapter ()
    {
        if ( summaryItemItemProvider == null )
        {
            summaryItemItemProvider = new SummaryItemItemProvider ( this );
        }

        return summaryItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MarkerEntry} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MarkerEntryItemProvider markerEntryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MarkerEntry}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMarkerEntryAdapter ()
    {
        if ( markerEntryItemProvider == null )
        {
            markerEntryItemProvider = new MarkerEntryItemProvider ( this );
        }

        return markerEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ManualOverride} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ManualOverrideItemProvider manualOverrideItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ManualOverride}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createManualOverrideAdapter ()
    {
        if ( manualOverrideItemProvider == null )
        {
            manualOverrideItemProvider = new ManualOverrideItemProvider ( this );
        }

        return manualOverrideItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DefaultMasterServer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DefaultMasterServerItemProvider defaultMasterServerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DefaultMasterServer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDefaultMasterServerAdapter ()
    {
        if ( defaultMasterServerItemProvider == null )
        {
            defaultMasterServerItemProvider = new DefaultMasterServerItemProvider ( this );
        }

        return defaultMasterServerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.CustomMasterServer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CustomMasterServerItemProvider customMasterServerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.CustomMasterServer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCustomMasterServerAdapter ()
    {
        if ( customMasterServerItemProvider == null )
        {
            customMasterServerItemProvider = new CustomMasterServerItemProvider ( this );
        }

        return customMasterServerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.AttributesSummary} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AttributesSummaryItemProvider attributesSummaryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.AttributesSummary}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAttributesSummaryAdapter ()
    {
        if ( attributesSummaryItemProvider == null )
        {
            attributesSummaryItemProvider = new AttributesSummaryItemProvider ( this );
        }

        return attributesSummaryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventLogger} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventLoggerItemProvider eventLoggerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventLogger}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventLoggerAdapter ()
    {
        if ( eventLoggerItemProvider == null )
        {
            eventLoggerItemProvider = new EventLoggerItemProvider ( this );
        }

        return eventLoggerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MonitorPool} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MonitorPoolItemProvider monitorPoolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MonitorPool}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMonitorPoolAdapter ()
    {
        if ( monitorPoolItemProvider == null )
        {
            monitorPoolItemProvider = new MonitorPoolItemProvider ( this );
        }

        return monitorPoolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventPool} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventPoolItemProvider eventPoolItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventPool}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventPoolAdapter ()
    {
        if ( eventPoolItemProvider == null )
        {
            eventPoolItemProvider = new EventPoolItemProvider ( this );
        }

        return eventPoolItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.SimpleDataMapper} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SimpleDataMapperItemProvider simpleDataMapperItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.SimpleDataMapper}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSimpleDataMapperAdapter ()
    {
        if ( simpleDataMapperItemProvider == null )
        {
            simpleDataMapperItemProvider = new SimpleDataMapperItemProvider ( this );
        }

        return simpleDataMapperItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.JdbcDataMapper} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected JdbcDataMapperItemProvider jdbcDataMapperItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.JdbcDataMapper}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createJdbcDataMapperAdapter ()
    {
        if ( jdbcDataMapperItemProvider == null )
        {
            jdbcDataMapperItemProvider = new JdbcDataMapperItemProvider ( this );
        }

        return jdbcDataMapperItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DataMapperEntry} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DataMapperEntryItemProvider dataMapperEntryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DataMapperEntry}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDataMapperEntryAdapter ()
    {
        if ( dataMapperEntryItemProvider == null )
        {
            dataMapperEntryItemProvider = new DataMapperEntryItemProvider ( this );
        }

        return dataMapperEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ValueMapper} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ValueMapperItemProvider valueMapperItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ValueMapper}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createValueMapperAdapter ()
    {
        if ( valueMapperItemProvider == null )
        {
            valueMapperItemProvider = new ValueMapperItemProvider ( this );
        }

        return valueMapperItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.PersistentItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PersistentItemItemProvider persistentItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.PersistentItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPersistentItemAdapter ()
    {
        if ( persistentItemItemProvider == null )
        {
            persistentItemItemProvider = new PersistentItemItemProvider ( this );
        }

        return persistentItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ProxyItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProxyItemItemProvider proxyItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ProxyItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProxyItemAdapter ()
    {
        if ( proxyItemItemProvider == null )
        {
            proxyItemItemProvider = new ProxyItemItemProvider ( this );
        }

        return proxyItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Scale} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScaleItemProvider scaleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Scale}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScaleAdapter ()
    {
        if ( scaleItemProvider == null )
        {
            scaleItemProvider = new ScaleItemProvider ( this );
        }

        return scaleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Negate} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NegateItemProvider negateItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Negate}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createNegateAdapter ()
    {
        if ( negateItemProvider == null )
        {
            negateItemProvider = new NegateItemProvider ( this );
        }

        return negateItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Rounding} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RoundingItemProvider roundingItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Rounding}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRoundingAdapter ()
    {
        if ( roundingItemProvider == null )
        {
            roundingItemProvider = new RoundingItemProvider ( this );
        }

        return roundingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ExternalEventMonitor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExternalEventMonitorItemProvider externalEventMonitorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ExternalEventMonitor}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExternalEventMonitorAdapter ()
    {
        if ( externalEventMonitorItemProvider == null )
        {
            externalEventMonitorItemProvider = new ExternalEventMonitorItemProvider ( this );
        }

        return externalEventMonitorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.StaticExternalEventFilter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StaticExternalEventFilterItemProvider staticExternalEventFilterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.StaticExternalEventFilter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createStaticExternalEventFilterAdapter ()
    {
        if ( staticExternalEventFilterItemProvider == null )
        {
            staticExternalEventFilterItemProvider = new StaticExternalEventFilterItemProvider ( this );
        }

        return staticExternalEventFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.SimpleExternalEventFilter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SimpleExternalEventFilterItemProvider simpleExternalEventFilterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.SimpleExternalEventFilter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSimpleExternalEventFilterAdapter ()
    {
        if ( simpleExternalEventFilterItemProvider == null )
        {
            simpleExternalEventFilterItemProvider = new SimpleExternalEventFilterItemProvider ( this );
        }

        return simpleExternalEventFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.TypedItemReference} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TypedItemReferenceItemProvider typedItemReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.TypedItemReference}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTypedItemReferenceAdapter ()
    {
        if ( typedItemReferenceItemProvider == null )
        {
            typedItemReferenceItemProvider = new TypedItemReferenceItemProvider ( this );
        }

        return typedItemReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.CodeFragment} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CodeFragmentItemProvider codeFragmentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.CodeFragment}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCodeFragmentAdapter ()
    {
        if ( codeFragmentItemProvider == null )
        {
            codeFragmentItemProvider = new CodeFragmentItemProvider ( this );
        }

        return codeFragmentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ScriptTimer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScriptTimerItemProvider scriptTimerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ScriptTimer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScriptTimerAdapter ()
    {
        if ( scriptTimerItemProvider == null )
        {
            scriptTimerItemProvider = new ScriptTimerItemProvider ( this );
        }

        return scriptTimerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ItemReference} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ItemReferenceItemProvider itemReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ItemReference}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createItemReferenceAdapter ()
    {
        if ( itemReferenceItemProvider == null )
        {
            itemReferenceItemProvider = new ItemReferenceItemProvider ( this );
        }

        return itemReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.FormulaItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FormulaItemItemProvider formulaItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.FormulaItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFormulaItemAdapter ()
    {
        if ( formulaItemItemProvider == null )
        {
            formulaItemItemProvider = new FormulaItemItemProvider ( this );
        }

        return formulaItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.FormulaItemOutbound} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FormulaItemOutboundItemProvider formulaItemOutboundItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.FormulaItemOutbound}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFormulaItemOutboundAdapter ()
    {
        if ( formulaItemOutboundItemProvider == null )
        {
            formulaItemOutboundItemProvider = new FormulaItemOutboundItemProvider ( this );
        }

        return formulaItemOutboundItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.FormulaItemInbound} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FormulaItemInboundItemProvider formulaItemInboundItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.FormulaItemInbound}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFormulaItemInboundAdapter ()
    {
        if ( formulaItemInboundItemProvider == null )
        {
            formulaItemInboundItemProvider = new FormulaItemInboundItemProvider ( this );
        }

        return formulaItemInboundItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.BooleanMonitor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BooleanMonitorItemProvider booleanMonitorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.BooleanMonitor}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBooleanMonitorAdapter ()
    {
        if ( booleanMonitorItemProvider == null )
        {
            booleanMonitorItemProvider = new BooleanMonitorItemProvider ( this );
        }

        return booleanMonitorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ListMonitor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ListMonitorItemProvider listMonitorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ListMonitor}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createListMonitorAdapter ()
    {
        if ( listMonitorItemProvider == null )
        {
            listMonitorItemProvider = new ListMonitorItemProvider ( this );
        }

        return listMonitorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ListMonitorEntry} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ListMonitorEntryItemProvider listMonitorEntryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ListMonitorEntry}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createListMonitorEntryAdapter ()
    {
        if ( listMonitorEntryItemProvider == null )
        {
            listMonitorEntryItemProvider = new ListMonitorEntryItemProvider ( this );
        }

        return listMonitorEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Average} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AverageItemProvider averageItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Average}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAverageAdapter ()
    {
        if ( averageItemProvider == null )
        {
            averageItemProvider = new AverageItemProvider ( this );
        }

        return averageItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MovingAverage} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MovingAverageItemProvider movingAverageItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MovingAverage}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMovingAverageAdapter ()
    {
        if ( movingAverageItemProvider == null )
        {
            movingAverageItemProvider = new MovingAverageItemProvider ( this );
        }

        return movingAverageItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.AverageItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AverageItemItemProvider averageItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.AverageItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAverageItemAdapter ()
    {
        if ( averageItemItemProvider == null )
        {
            averageItemItemProvider = new AverageItemItemProvider ( this );
        }

        return averageItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MovingAverageItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MovingAverageItemItemProvider movingAverageItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MovingAverageItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMovingAverageItemAdapter ()
    {
        if ( movingAverageItemItemProvider == null )
        {
            movingAverageItemItemProvider = new MovingAverageItemItemProvider ( this );
        }

        return movingAverageItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Blockings} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BlockingsItemProvider blockingsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Blockings}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBlockingsAdapter ()
    {
        if ( blockingsItemProvider == null )
        {
            blockingsItemProvider = new BlockingsItemProvider ( this );
        }

        return blockingsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.BlockGroup} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BlockGroupItemProvider blockGroupItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.BlockGroup}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBlockGroupAdapter ()
    {
        if ( blockGroupItemProvider == null )
        {
            blockGroupItemProvider = new BlockGroupItemProvider ( this );
        }

        return blockGroupItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.BlockHandler} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BlockHandlerItemProvider blockHandlerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.BlockHandler}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBlockHandlerAdapter ()
    {
        if ( blockHandlerItemProvider == null )
        {
            blockHandlerItemProvider = new BlockHandlerItemProvider ( this );
        }

        return blockHandlerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.Block} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BlockItemProvider blockItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.Block}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBlockAdapter ()
    {
        if ( blockItemProvider == null )
        {
            blockItemProvider = new BlockItemProvider ( this );
        }

        return blockItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.GlobalSummaryItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GlobalSummaryItemItemProvider globalSummaryItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.GlobalSummaryItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createGlobalSummaryItemAdapter ()
    {
        if ( globalSummaryItemItemProvider == null )
        {
            globalSummaryItemItemProvider = new GlobalSummaryItemItemProvider ( this );
        }

        return globalSummaryItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.WeakReferenceDataSourceItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected WeakReferenceDataSourceItemItemProvider weakReferenceDataSourceItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.WeakReferenceDataSourceItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createWeakReferenceDataSourceItemAdapter ()
    {
        if ( weakReferenceDataSourceItemItemProvider == null )
        {
            weakReferenceDataSourceItemItemProvider = new WeakReferenceDataSourceItemItemProvider ( this );
        }

        return weakReferenceDataSourceItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.AlarmsEventsExporter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AlarmsEventsExporterItemProvider alarmsEventsExporterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.AlarmsEventsExporter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAlarmsEventsExporterAdapter ()
    {
        if ( alarmsEventsExporterItemProvider == null )
        {
            alarmsEventsExporterItemProvider = new AlarmsEventsExporterItemProvider ( this );
        }

        return alarmsEventsExporterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.AlarmsEventsConnection} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AlarmsEventsConnectionItemProvider alarmsEventsConnectionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.AlarmsEventsConnection}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAlarmsEventsConnectionAdapter ()
    {
        if ( alarmsEventsConnectionItemProvider == null )
        {
            alarmsEventsConnectionItemProvider = new AlarmsEventsConnectionItemProvider ( this );
        }

        return alarmsEventsConnectionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MonitorPoolProxy} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MonitorPoolProxyItemProvider monitorPoolProxyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MonitorPoolProxy}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMonitorPoolProxyAdapter ()
    {
        if ( monitorPoolProxyItemProvider == null )
        {
            monitorPoolProxyItemProvider = new MonitorPoolProxyItemProvider ( this );
        }

        return monitorPoolProxyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventPoolProxy} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventPoolProxyItemProvider eventPoolProxyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventPoolProxy}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventPoolProxyAdapter ()
    {
        if ( eventPoolProxyItemProvider == null )
        {
            eventPoolProxyItemProvider = new EventPoolProxyItemProvider ( this );
        }

        return eventPoolProxyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.AlarmsEventsModule} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AlarmsEventsModuleItemProvider alarmsEventsModuleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.AlarmsEventsModule}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAlarmsEventsModuleAdapter ()
    {
        if ( alarmsEventsModuleItemProvider == null )
        {
            alarmsEventsModuleItemProvider = new AlarmsEventsModuleItemProvider ( this );
        }

        return alarmsEventsModuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.AknProxy} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AknProxyItemProvider aknProxyItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.AknProxy}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAknProxyAdapter ()
    {
        if ( aknProxyItemProvider == null )
        {
            aknProxyItemProvider = new AknProxyItemProvider ( this );
        }

        return aknProxyItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.PullEvents} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PullEventsItemProvider pullEventsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.PullEvents}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPullEventsAdapter ()
    {
        if ( pullEventsItemProvider == null )
        {
            pullEventsItemProvider = new PullEventsItemProvider ( this );
        }

        return pullEventsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.JdbcUserServiceModule} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected JdbcUserServiceModuleItemProvider jdbcUserServiceModuleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.JdbcUserServiceModule}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createJdbcUserServiceModuleAdapter ()
    {
        if ( jdbcUserServiceModuleItemProvider == null )
        {
            jdbcUserServiceModuleItemProvider = new JdbcUserServiceModuleItemProvider ( this );
        }

        return jdbcUserServiceModuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.JdbcUserService} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected JdbcUserServiceItemProvider jdbcUserServiceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.JdbcUserService}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createJdbcUserServiceAdapter ()
    {
        if ( jdbcUserServiceItemProvider == null )
        {
            jdbcUserServiceItemProvider = new JdbcUserServiceItemProvider ( this );
        }

        return jdbcUserServiceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DefaultValueArchiveServer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DefaultValueArchiveServerItemProvider defaultValueArchiveServerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DefaultValueArchiveServer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDefaultValueArchiveServerAdapter ()
    {
        if ( defaultValueArchiveServerItemProvider == null )
        {
            defaultValueArchiveServerItemProvider = new DefaultValueArchiveServerItemProvider ( this );
        }

        return defaultValueArchiveServerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.HistoricalDataExporter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected HistoricalDataExporterItemProvider historicalDataExporterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.HistoricalDataExporter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createHistoricalDataExporterAdapter ()
    {
        if ( historicalDataExporterItemProvider == null )
        {
            historicalDataExporterItemProvider = new HistoricalDataExporterItemProvider ( this );
        }

        return historicalDataExporterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ValueArchive} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ValueArchiveItemProvider valueArchiveItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ValueArchive}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createValueArchiveAdapter ()
    {
        if ( valueArchiveItemProvider == null )
        {
            valueArchiveItemProvider = new ValueArchiveItemProvider ( this );
        }

        return valueArchiveItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ConfigurationAdministratorExporter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConfigurationAdministratorExporterItemProvider configurationAdministratorExporterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ConfigurationAdministratorExporter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConfigurationAdministratorExporterAdapter ()
    {
        if ( configurationAdministratorExporterItemProvider == null )
        {
            configurationAdministratorExporterItemProvider = new ConfigurationAdministratorExporterItemProvider ( this );
        }

        return configurationAdministratorExporterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ReferenceItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ReferenceItemItemProvider referenceItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ReferenceItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createReferenceItemAdapter ()
    {
        if ( referenceItemItemProvider == null )
        {
            referenceItemItemProvider = new ReferenceItemItemProvider ( this );
        }

        return referenceItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventStorageJdbc} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventStorageJdbcItemProvider eventStorageJdbcItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventStorageJdbc}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventStorageJdbcAdapter ()
    {
        if ( eventStorageJdbcItemProvider == null )
        {
            eventStorageJdbcItemProvider = new EventStorageJdbcItemProvider ( this );
        }

        return eventStorageJdbcItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventStoragePostgres} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventStoragePostgresItemProvider eventStoragePostgresItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventStoragePostgres}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventStoragePostgresAdapter ()
    {
        if ( eventStoragePostgresItemProvider == null )
        {
            eventStoragePostgresItemProvider = new EventStoragePostgresItemProvider ( this );
        }

        return eventStoragePostgresItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.RestExporter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RestExporterItemProvider restExporterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.RestExporter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRestExporterAdapter ()
    {
        if ( restExporterItemProvider == null )
        {
            restExporterItemProvider = new RestExporterItemProvider ( this );
        }

        return restExporterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.HttpService} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected HttpServiceItemProvider httpServiceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.HttpService}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createHttpServiceAdapter ()
    {
        if ( httpServiceItemProvider == null )
        {
            httpServiceItemProvider = new HttpServiceItemProvider ( this );
        }

        return httpServiceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.TransientItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TransientItemItemProvider transientItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.TransientItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTransientItemAdapter ()
    {
        if ( transientItemItemProvider == null )
        {
            transientItemItemProvider = new TransientItemItemProvider ( this );
        }

        return transientItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DefaultEquinoxApplication} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DefaultEquinoxApplicationItemProvider defaultEquinoxApplicationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DefaultEquinoxApplication}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDefaultEquinoxApplicationAdapter ()
    {
        if ( defaultEquinoxApplicationItemProvider == null )
        {
            defaultEquinoxApplicationItemProvider = new DefaultEquinoxApplicationItemProvider ( this );
        }

        return defaultEquinoxApplicationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ChangeCounterItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChangeCounterItemItemProvider changeCounterItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ChangeCounterItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createChangeCounterItemAdapter ()
    {
        if ( changeCounterItemItemProvider == null )
        {
            changeCounterItemItemProvider = new ChangeCounterItemItemProvider ( this );
        }

        return changeCounterItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.BufferedValue} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BufferedValueItemProvider bufferedValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.BufferedValue}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBufferedValueAdapter ()
    {
        if ( bufferedValueItemProvider == null )
        {
            bufferedValueItemProvider = new BufferedValueItemProvider ( this );
        }

        return bufferedValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.TelnetConsole} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TelnetConsoleItemProvider telnetConsoleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.TelnetConsole}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTelnetConsoleAdapter ()
    {
        if ( telnetConsoleItemProvider == null )
        {
            telnetConsoleItemProvider = new TelnetConsoleItemProvider ( this );
        }

        return telnetConsoleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventInjectorPostgres} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventInjectorPostgresItemProvider eventInjectorPostgresItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventInjectorPostgres}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventInjectorPostgresAdapter ()
    {
        if ( eventInjectorPostgresItemProvider == null )
        {
            eventInjectorPostgresItemProvider = new EventInjectorPostgresItemProvider ( this );
        }

        return eventInjectorPostgresItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventInjectorJdbc} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventInjectorJdbcItemProvider eventInjectorJdbcItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventInjectorJdbc}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventInjectorJdbcAdapter ()
    {
        if ( eventInjectorJdbcItemProvider == null )
        {
            eventInjectorJdbcItemProvider = new EventInjectorJdbcItemProvider ( this );
        }

        return eventInjectorJdbcItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ProfileConfiguration} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProfileConfigurationItemProvider profileConfigurationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ProfileConfiguration}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProfileConfigurationAdapter ()
    {
        if ( profileConfigurationItemProvider == null )
        {
            profileConfigurationItemProvider = new ProfileConfigurationItemProvider ( this );
        }

        return profileConfigurationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventInjectorSyslog} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventInjectorSyslogItemProvider eventInjectorSyslogItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventInjectorSyslog}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventInjectorSyslogAdapter ()
    {
        if ( eventInjectorSyslogItemProvider == null )
        {
            eventInjectorSyslogItemProvider = new EventInjectorSyslogItemProvider ( this );
        }

        return eventInjectorSyslogItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.EventInjectorManager} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EventInjectorManagerItemProvider eventInjectorManagerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.EventInjectorManager}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEventInjectorManagerAdapter ()
    {
        if ( eventInjectorManagerItemProvider == null )
        {
            eventInjectorManagerItemProvider = new EventInjectorManagerItemProvider ( this );
        }

        return eventInjectorManagerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DefaultStorageHandler} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DefaultStorageHandlerItemProvider defaultStorageHandlerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DefaultStorageHandler}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDefaultStorageHandlerAdapter ()
    {
        if ( defaultStorageHandlerItemProvider == null )
        {
            defaultStorageHandlerItemProvider = new DefaultStorageHandlerItemProvider ( this );
        }

        return defaultStorageHandlerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.IncludeEventFilter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IncludeEventFilterItemProvider includeEventFilterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.IncludeEventFilter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createIncludeEventFilterAdapter ()
    {
        if ( includeEventFilterItemProvider == null )
        {
            includeEventFilterItemProvider = new IncludeEventFilterItemProvider ( this );
        }

        return includeEventFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ExcludeEventFilter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExcludeEventFilterItemProvider excludeEventFilterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ExcludeEventFilter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExcludeEventFilterAdapter ()
    {
        if ( excludeEventFilterItemProvider == null )
        {
            excludeEventFilterItemProvider = new ExcludeEventFilterItemProvider ( this );
        }

        return excludeEventFilterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ScriptEventHandler} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ScriptEventHandlerItemProvider scriptEventHandlerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ScriptEventHandler}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createScriptEventHandlerAdapter ()
    {
        if ( scriptEventHandlerItemProvider == null )
        {
            scriptEventHandlerItemProvider = new ScriptEventHandlerItemProvider ( this );
        }

        return scriptEventHandlerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.MailEventHandler} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MailEventHandlerItemProvider mailEventHandlerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.MailEventHandler}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMailEventHandlerAdapter ()
    {
        if ( mailEventHandlerItemProvider == null )
        {
            mailEventHandlerItemProvider = new MailEventHandlerItemProvider ( this );
        }

        return mailEventHandlerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.SfpDataAccessConnection} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SfpDataAccessConnectionItemProvider sfpDataAccessConnectionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.SfpDataAccessConnection}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSfpDataAccessConnectionAdapter ()
    {
        if ( sfpDataAccessConnectionItemProvider == null )
        {
            sfpDataAccessConnectionItemProvider = new SfpDataAccessConnectionItemProvider ( this );
        }

        return sfpDataAccessConnectionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.DeltaItem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DeltaItemItemProvider deltaItemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.DeltaItem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDeltaItemAdapter ()
    {
        if ( deltaItemItemProvider == null )
        {
            deltaItemItemProvider = new DeltaItemItemProvider ( this );
        }

        return deltaItemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.world.osgi.ArchiveConfiguration} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ArchiveConfigurationItemProvider archiveConfigurationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.world.osgi.ArchiveConfiguration}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createArchiveConfigurationAdapter ()
    {
        if ( archiveConfigurationItemProvider == null )
        {
            archiveConfigurationItemProvider = new ArchiveConfigurationItemProvider ( this );
        }

        return archiveConfigurationItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders ()
    {
        return childCreationExtenderManager.getChildCreationExtenders ();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Collection<?> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
    {
        return childCreationExtenderManager.getNewChildDescriptors ( object, editingDomain );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ResourceLocator getResourceLocator ()
    {
        return childCreationExtenderManager;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose ()
    {
        if ( dataAccessConnectionItemProvider != null )
            dataAccessConnectionItemProvider.dispose ();
        if ( dataAccessExporterItemProvider != null )
            dataAccessExporterItemProvider.dispose ();
        if ( sourceItemItemProvider != null )
            sourceItemItemProvider.dispose ();
        if ( itemExportItemProvider != null )
            itemExportItemProvider.dispose ();
        if ( itemInformationItemProvider != null )
            itemInformationItemProvider.dispose ();
        if ( levelMonitorItemProvider != null )
            levelMonitorItemProvider.dispose ();
        if ( scriptItemItemProvider != null )
            scriptItemItemProvider.dispose ();
        if ( importItemItemProvider != null )
            importItemItemProvider.dispose ();
        if ( summaryGroupItemProvider != null )
            summaryGroupItemProvider.dispose ();
        if ( markerGroupItemProvider != null )
            markerGroupItemProvider.dispose ();
        if ( markersItemProvider != null )
            markersItemProvider.dispose ();
        if ( constantItemItemProvider != null )
            constantItemItemProvider.dispose ();
        if ( summaryItemItemProvider != null )
            summaryItemItemProvider.dispose ();
        if ( markerEntryItemProvider != null )
            markerEntryItemProvider.dispose ();
        if ( manualOverrideItemProvider != null )
            manualOverrideItemProvider.dispose ();
        if ( defaultMasterServerItemProvider != null )
            defaultMasterServerItemProvider.dispose ();
        if ( customMasterServerItemProvider != null )
            customMasterServerItemProvider.dispose ();
        if ( attributesSummaryItemProvider != null )
            attributesSummaryItemProvider.dispose ();
        if ( eventLoggerItemProvider != null )
            eventLoggerItemProvider.dispose ();
        if ( monitorPoolItemProvider != null )
            monitorPoolItemProvider.dispose ();
        if ( eventPoolItemProvider != null )
            eventPoolItemProvider.dispose ();
        if ( simpleDataMapperItemProvider != null )
            simpleDataMapperItemProvider.dispose ();
        if ( jdbcDataMapperItemProvider != null )
            jdbcDataMapperItemProvider.dispose ();
        if ( dataMapperEntryItemProvider != null )
            dataMapperEntryItemProvider.dispose ();
        if ( valueMapperItemProvider != null )
            valueMapperItemProvider.dispose ();
        if ( persistentItemItemProvider != null )
            persistentItemItemProvider.dispose ();
        if ( proxyItemItemProvider != null )
            proxyItemItemProvider.dispose ();
        if ( scaleItemProvider != null )
            scaleItemProvider.dispose ();
        if ( negateItemProvider != null )
            negateItemProvider.dispose ();
        if ( roundingItemProvider != null )
            roundingItemProvider.dispose ();
        if ( externalEventMonitorItemProvider != null )
            externalEventMonitorItemProvider.dispose ();
        if ( staticExternalEventFilterItemProvider != null )
            staticExternalEventFilterItemProvider.dispose ();
        if ( simpleExternalEventFilterItemProvider != null )
            simpleExternalEventFilterItemProvider.dispose ();
        if ( typedItemReferenceItemProvider != null )
            typedItemReferenceItemProvider.dispose ();
        if ( codeFragmentItemProvider != null )
            codeFragmentItemProvider.dispose ();
        if ( scriptTimerItemProvider != null )
            scriptTimerItemProvider.dispose ();
        if ( itemReferenceItemProvider != null )
            itemReferenceItemProvider.dispose ();
        if ( formulaItemItemProvider != null )
            formulaItemItemProvider.dispose ();
        if ( formulaItemOutboundItemProvider != null )
            formulaItemOutboundItemProvider.dispose ();
        if ( formulaItemInboundItemProvider != null )
            formulaItemInboundItemProvider.dispose ();
        if ( booleanMonitorItemProvider != null )
            booleanMonitorItemProvider.dispose ();
        if ( listMonitorItemProvider != null )
            listMonitorItemProvider.dispose ();
        if ( listMonitorEntryItemProvider != null )
            listMonitorEntryItemProvider.dispose ();
        if ( averageItemProvider != null )
            averageItemProvider.dispose ();
        if ( movingAverageItemProvider != null )
            movingAverageItemProvider.dispose ();
        if ( averageItemItemProvider != null )
            averageItemItemProvider.dispose ();
        if ( movingAverageItemItemProvider != null )
            movingAverageItemItemProvider.dispose ();
        if ( blockingsItemProvider != null )
            blockingsItemProvider.dispose ();
        if ( blockGroupItemProvider != null )
            blockGroupItemProvider.dispose ();
        if ( blockHandlerItemProvider != null )
            blockHandlerItemProvider.dispose ();
        if ( blockItemProvider != null )
            blockItemProvider.dispose ();
        if ( globalSummaryItemItemProvider != null )
            globalSummaryItemItemProvider.dispose ();
        if ( weakReferenceDataSourceItemItemProvider != null )
            weakReferenceDataSourceItemItemProvider.dispose ();
        if ( alarmsEventsExporterItemProvider != null )
            alarmsEventsExporterItemProvider.dispose ();
        if ( alarmsEventsConnectionItemProvider != null )
            alarmsEventsConnectionItemProvider.dispose ();
        if ( monitorPoolProxyItemProvider != null )
            monitorPoolProxyItemProvider.dispose ();
        if ( eventPoolProxyItemProvider != null )
            eventPoolProxyItemProvider.dispose ();
        if ( alarmsEventsModuleItemProvider != null )
            alarmsEventsModuleItemProvider.dispose ();
        if ( aknProxyItemProvider != null )
            aknProxyItemProvider.dispose ();
        if ( pullEventsItemProvider != null )
            pullEventsItemProvider.dispose ();
        if ( jdbcUserServiceModuleItemProvider != null )
            jdbcUserServiceModuleItemProvider.dispose ();
        if ( jdbcUserServiceItemProvider != null )
            jdbcUserServiceItemProvider.dispose ();
        if ( defaultValueArchiveServerItemProvider != null )
            defaultValueArchiveServerItemProvider.dispose ();
        if ( historicalDataExporterItemProvider != null )
            historicalDataExporterItemProvider.dispose ();
        if ( valueArchiveItemProvider != null )
            valueArchiveItemProvider.dispose ();
        if ( configurationAdministratorExporterItemProvider != null )
            configurationAdministratorExporterItemProvider.dispose ();
        if ( referenceItemItemProvider != null )
            referenceItemItemProvider.dispose ();
        if ( eventStorageJdbcItemProvider != null )
            eventStorageJdbcItemProvider.dispose ();
        if ( eventStoragePostgresItemProvider != null )
            eventStoragePostgresItemProvider.dispose ();
        if ( restExporterItemProvider != null )
            restExporterItemProvider.dispose ();
        if ( httpServiceItemProvider != null )
            httpServiceItemProvider.dispose ();
        if ( transientItemItemProvider != null )
            transientItemItemProvider.dispose ();
        if ( defaultEquinoxApplicationItemProvider != null )
            defaultEquinoxApplicationItemProvider.dispose ();
        if ( changeCounterItemItemProvider != null )
            changeCounterItemItemProvider.dispose ();
        if ( bufferedValueItemProvider != null )
            bufferedValueItemProvider.dispose ();
        if ( telnetConsoleItemProvider != null )
            telnetConsoleItemProvider.dispose ();
        if ( eventInjectorPostgresItemProvider != null )
            eventInjectorPostgresItemProvider.dispose ();
        if ( eventInjectorJdbcItemProvider != null )
            eventInjectorJdbcItemProvider.dispose ();
        if ( profileConfigurationItemProvider != null )
            profileConfigurationItemProvider.dispose ();
        if ( eventInjectorSyslogItemProvider != null )
            eventInjectorSyslogItemProvider.dispose ();
        if ( eventInjectorManagerItemProvider != null )
            eventInjectorManagerItemProvider.dispose ();
        if ( defaultStorageHandlerItemProvider != null )
            defaultStorageHandlerItemProvider.dispose ();
        if ( includeEventFilterItemProvider != null )
            includeEventFilterItemProvider.dispose ();
        if ( excludeEventFilterItemProvider != null )
            excludeEventFilterItemProvider.dispose ();
        if ( scriptEventHandlerItemProvider != null )
            scriptEventHandlerItemProvider.dispose ();
        if ( mailEventHandlerItemProvider != null )
            mailEventHandlerItemProvider.dispose ();
        if ( sfpDataAccessConnectionItemProvider != null )
            sfpDataAccessConnectionItemProvider.dispose ();
        if ( deltaItemItemProvider != null )
            deltaItemItemProvider.dispose ();
        if ( archiveConfigurationItemProvider != null )
            archiveConfigurationItemProvider.dispose ();
    }

}
