/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.AnnouncerType;
import org.eclipse.scada.da.server.exporter.ConfigurationException;
import org.eclipse.scada.da.server.exporter.ConfigurationType;
import org.eclipse.scada.da.server.exporter.DocumentRoot;
import org.eclipse.scada.da.server.exporter.ExportType;
import org.eclipse.scada.da.server.exporter.ExporterPackage;
import org.eclipse.scada.da.server.exporter.HiveExport;
import org.eclipse.scada.da.server.exporter.HiveFactory;
import org.eclipse.scada.da.server.exporter.HiveType;
import org.eclipse.scada.da.server.exporter.ServiceLoaderHiveFactory;
import org.eclipse.scada.da.server.exporter.util.ExporterResourceFactoryImpl;
import org.eclipse.scada.utils.init.ServiceLoaderProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private final List<HiveExport> hives = new LinkedList<HiveExport>();
    private final List<String> announcers = new LinkedList<String>();
    private final HiveFactory defaultHiveFactory;

    public Controller(DocumentRoot documentRoot) throws ConfigurationException {
        this((HiveFactory)new ServiceLoaderHiveFactory(), documentRoot.getConfiguration());
    }

    public Controller(String file) throws IOException, ConfigurationException {
        this(Controller.parse(URI.createFileURI((String)file)));
    }

    public Controller(File file) throws IOException, ConfigurationException {
        this(Controller.parse(URI.createFileURI((String)file.toString())));
    }

    public Controller(HiveFactory defaultHiveFactory, ConfigurationType configuration) throws ConfigurationException {
        this.defaultHiveFactory = defaultHiveFactory;
        this.configure(configuration);
    }

    public Controller(HiveFactory defaultHiveFactory, URL url) throws ConfigurationException {
        this(defaultHiveFactory, Controller.parse(URI.createURI((String)url.toString())).getConfiguration());
    }

    private static DocumentRoot parse(URI uri) throws ConfigurationException {
        ExporterPackage.eINSTANCE.eClass();
        ServiceLoaderProcessor.initialize((Object)"emf", (ClassLoader)Thread.currentThread().getContextClassLoader());
        try {
            ResourceSetImpl rs = new ResourceSetImpl();
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ExporterResourceFactoryImpl());
            Resource resource = rs.createResource(uri);
            resource.load(null);
            DocumentRoot result = (DocumentRoot)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)ExporterPackage.Literals.DOCUMENT_ROOT);
            if (result == null) {
                throw new IllegalStateException("Document does not contain a configuration");
            }
            return result;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to parse document", e);
        }
    }

    private void configure(ConfigurationType configuration) throws ConfigurationException {
        for (AnnouncerType announcer : configuration.getAnnouncer()) {
            String klass = announcer.getClass_();
            this.announcers.add(klass);
        }
        for (HiveType hive : configuration.getHive()) {
            Hive hiveInstance;
            String ref = hive.getRef();
            try {
                hiveInstance = this.defaultHiveFactory.createHive(ref, hive.getConfiguration());
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create hive: " + hive.getRef(), e);
            }
            if (hiveInstance == null) {
                throw new ConfigurationException("Failed to load hive: " + hive.getRef());
            }
            HiveExport hiveExport = new HiveExport(hiveInstance);
            for (ExportType export : hive.getExport()) {
                try {
                    logger.debug("Adding export: {}", (Object)export.getUri());
                    hiveExport.addExport(export.getUri());
                }
                catch (ConfigurationException e) {
                    logger.error(String.format("Unable to configure export (%s) for hive (%s)", export.getUri(), hive.getRef()), (Throwable)e);
                }
            }
            this.hives.add(hiveExport);
        }
    }

    public synchronized void start() throws Exception {
        for (HiveExport hive : this.hives) {
            hive.start();
        }
    }

    public synchronized void stop() throws Exception {
        for (HiveExport hive : this.hives) {
            hive.stop();
        }
    }
}

