/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.summary;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.server.osgi.summary.FactoryImpl;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ObjectPoolTracker<DataSource> tracker;
    private ExecutorService executor;
    private ObjectPoolImpl<DataSource> pool;
    private FactoryImpl factory;
    private ServiceRegistration<?> factoryHandle;

    public void start(BundleContext context) throws Exception {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.pool = new ObjectPoolImpl();
        ObjectPoolHelper.registerObjectPool((BundleContext)context, this.pool, DataSource.class);
        this.tracker = new ObjectPoolTracker(context, DataSource.class);
        this.tracker.open();
        this.factory = new FactoryImpl(this.executor, context, this.tracker, (ManageableObjectPool<DataSource>)this.pool);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A data source status summarizer");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.osgi.summary.attribute");
        this.factoryHandle = context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.factoryHandle.unregister();
        this.factory.dispose();
        this.factory = null;
        this.tracker.close();
        this.tracker = null;
        this.pool.dispose();
        this.pool = null;
        this.executor.shutdown();
        this.executor = null;
    }
}

