/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.jdbc;

import com.google.common.collect.Interner;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.scada.ae.server.storage.Storage;
import org.eclipse.scada.ae.server.storage.jdbc.JdbcStorage;
import org.eclipse.scada.ae.server.storage.jdbc.JdbcStorageDao;
import org.eclipse.scada.utils.interner.InternerHelper;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String SPECIFIC_PREFIX = "org.eclipse.scada.ae.server.storage.jdbc";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private JdbcStorage jdbcStorage;
    private ServiceRegistration<?> jdbcStorageHandle;
    private final int maxLength = 4000;
    private SingleServiceTracker<DataSourceFactory> dataSouceFactoryTracker;
    private Interner<String> stringInterner;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.stringInterner = InternerHelper.makeInterner((String)"org.eclipse.scada.ae.monitor.dataitem.stringInternerType", (String)"weak");
        String driver = DataSourceHelper.getDriver((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
        if (driver == null) {
            logger.error("JDBC driver is not set");
            throw new IllegalStateException("JDBC driver name is not set");
        }
        logger.info("Using driver: {}", (Object)driver);
        Filter filter = context.createFilter("(&(objectClass=" + DataSourceFactory.class.getName() + ")(" + "osgi.jdbc.driver.class" + "=" + driver + "))");
        this.dataSouceFactoryTracker = new SingleServiceTracker(bundleContext, filter, (SingleServiceListener)new SingleServiceListener<DataSourceFactory>(){

            public void serviceChange(ServiceReference<DataSourceFactory> reference, DataSourceFactory dsf) {
                logger.info("Service change: {}", reference);
                try {
                    Activator.this.deactivate();
                }
                catch (Exception e) {
                    logger.error("an error occured on deactivating ae jdbc storage", (Throwable)e);
                }
                if (dsf != null) {
                    try {
                        Activator.this.activate(dsf);
                    }
                    catch (Exception e) {
                        logger.error("an error occured on activating ae jdbc storage", (Throwable)e);
                    }
                }
            }
        });
        this.dataSouceFactoryTracker.open();
    }

    private void activate(DataSourceFactory dataSourceFactory) throws Exception {
        logger.info("Activating: {}", (Object)dataSourceFactory);
        Properties dbProperties = DataSourceHelper.getDataSourceProperties((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
        Long loginTimeout = DataSourceHelper.getLoginTimeout((Properties)System.getProperties(), (String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
        this.jdbcStorage = this.createJdbcStorage(dataSourceFactory, dbProperties, DataSourceHelper.isConnectionPool((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc", (boolean)false), loginTimeout);
        this.jdbcStorage.start();
        Hashtable<String, Object> properties = new Hashtable<String, Object>(2);
        ((Dictionary)properties).put("service.description", "JDBC implementation for org.eclipse.scada.ae.server.storage.Storage");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("osgi.command.scope", "ae");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"cleanupArchive", "showQueueSize"});
        this.jdbcStorageHandle = context.registerService(new String[]{JdbcStorage.class.getName(), Storage.class.getName()}, (Object)this.jdbcStorage, properties);
    }

    private void deactivate() throws Exception {
        logger.info("Deactivating");
        if (this.jdbcStorageHandle != null) {
            this.jdbcStorageHandle.unregister();
            this.jdbcStorageHandle = null;
        }
        if (this.jdbcStorage != null) {
            this.jdbcStorage.dispose();
            this.jdbcStorage = null;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.dataSouceFactoryTracker != null) {
            this.dataSouceFactoryTracker.close();
        }
        this.deactivate();
        context = null;
    }

    private JdbcStorage createJdbcStorage(DataSourceFactory dataSourceFactory, Properties dbParameters, boolean usePool, Long loginTimeout) throws SQLException {
        JdbcStorageDao jdbcStorageDao = new JdbcStorageDao(dataSourceFactory, dbParameters, usePool, loginTimeout, this.stringInterner);
        jdbcStorageDao.setInstance(System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.instance", "default"));
        jdbcStorageDao.setMaxLength(Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.maxlength", 4000));
        if (!System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.schema", "").trim().isEmpty()) {
            jdbcStorageDao.setSchema(String.valueOf(System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.schema")) + ".");
        }
        return new JdbcStorage(jdbcStorageDao);
    }
}

