/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.jdbc;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.BaseStorage;
import org.eclipse.scada.ae.server.storage.Query;
import org.eclipse.scada.ae.server.storage.StoreListener;
import org.eclipse.scada.ae.server.storage.jdbc.JdbcQuery;
import org.eclipse.scada.ae.server.storage.jdbc.StorageDao;
import org.eclipse.scada.utils.collection.BoundedPriorityQueueSet;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.filter.FilterParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorage
extends BaseStorage {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorage.class);
    private ScheduledExecutorService executor;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final StorageDao jdbcStorageDao;
    private final List<JdbcQuery> openQueries = new CopyOnWriteArrayList<JdbcQuery>();
    private final BoundedPriorityQueueSet<Event> errorQueue = new BoundedPriorityQueueSet(1000);

    public JdbcStorage(StorageDao jdbcStorageDao) {
        this.jdbcStorageDao = jdbcStorageDao;
    }

    public Event store(final Event event, final StoreListener listener) {
        this.queueSize.incrementAndGet();
        final Event eventToStore = this.createEvent(event);
        logger.debug("Save Event to database: {}", (Object)event);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JdbcStorage.this.jdbcStorageDao.storeEvent(eventToStore);
                    JdbcStorage.this.queueSize.decrementAndGet();
                    if (listener != null) {
                        listener.notify(eventToStore);
                    }
                    logger.debug("Event saved to database - remaining in queue: {}, event: {}", (Object)JdbcStorage.this.queueSize.get(), (Object)event);
                }
                catch (Exception e) {
                    JdbcStorage.this.queueSize.decrementAndGet();
                    JdbcStorage.this.errorQueue.offer((Object)eventToStore);
                    logger.error("Exception occured ({}) while saving Event to database: {}", (Object)e, (Object)event);
                    logger.info("Exception was", (Throwable)e);
                }
            }
        });
        return eventToStore;
    }

    private void drainErrorQueue() {
        final int size = this.errorQueue.size();
        final HashSet eventsNotSaved = new HashSet();
        int i = 0;
        while (i < size) {
            final int ii = i;
            final Event event = (Event)this.errorQueue.poll();
            if (event != null) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Event existingEvent = JdbcStorage.this.jdbcStorageDao.loadEvent(event.getId());
                            if (existingEvent == null) {
                                JdbcStorage.this.jdbcStorageDao.storeEvent(event);
                                logger.debug("Event saved to database which could not be saved before - remaining in queue: {}, event: {}", (Object)(size - ii), (Object)event);
                            }
                        }
                        catch (Exception e) {
                            eventsNotSaved.add(event);
                            logger.error("Exception occured ({}) while saving Event to database: {}", (Object)e, (Object)event);
                            logger.info("Exception was", (Throwable)e);
                        }
                    }
                });
            }
            ++i;
        }
        for (Event event : eventsNotSaved) {
            this.errorQueue.offer((Object)event);
        }
    }

    public Query query(String filter) throws Exception {
        logger.debug("Query requested {}", (Object)filter);
        return new JdbcQuery(this.jdbcStorageDao, new FilterParser(filter).getFilter(), this.executor, this.openQueries);
    }

    public Event update(final UUID id, final String comment, final StoreListener listener) throws Exception {
        this.queueSize.incrementAndGet();
        logger.debug("Update of comment on event {} with comment '{}'", (Object)id, (Object)comment);
        final Event event = Event.create().event(this.jdbcStorageDao.loadEvent(id)).attribute(Event.Fields.COMMENT, (Object)comment).build();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JdbcStorage.this.jdbcStorageDao.updateComment(id, comment);
                    logger.debug("Comment saved to database - remaining queue: {}, event: {}", (Object)JdbcStorage.this.queueSize.get(), (Object)event);
                    JdbcStorage.this.queueSize.decrementAndGet();
                    if (listener != null) {
                        listener.notify(event);
                    }
                }
                catch (Exception e) {
                    JdbcStorage.this.queueSize.decrementAndGet();
                    logger.error("Exception occured ({}) while saving Comment to database: {}", (Object)e, (Object)event);
                    logger.info("Exception was", (Throwable)e);
                }
            }
        });
        return event;
    }

    public void start() throws Exception {
        logger.info("jdbcStorageDAO instanciated");
        this.executor = new ScheduledExportedExecutorService(((Object)((Object)this)).getClass().getCanonicalName(), 1);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                JdbcStorage.this.drainErrorQueue();
            }
        }, 10000L, 10000L, TimeUnit.SECONDS);
    }

    public void dispose() {
        List<Runnable> openTasks = this.executor.shutdownNow();
        int numOfOpenTasks = openTasks.size();
        if (numOfOpenTasks > 0) {
            int numOfOpenTasksRemaining = numOfOpenTasks;
            logger.info("jdbcStorageDAO is beeing shut down, but there are still {} open tasks", (Object)numOfOpenTasks);
            for (Runnable runnable : openTasks) {
                runnable.run();
                logger.debug("jdbcStorageDAO is beeing shut down, but there are still {} open tasks", (Object)(--numOfOpenTasksRemaining));
            }
        }
        this.jdbcStorageDao.dispose();
        logger.info("jdbcStorageDAO destroyed");
    }

    public void cleanup() {
        logger.info("Cleaning up archive...");
        this.jdbcStorageDao.cleanupArchive();
        logger.info("Cleaning up archive... done!");
    }

    public void showQueueSize() {
        System.out.println("Storage queue size: " + this.queueSize.get());
    }
}

