/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.jdbc.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.ca.common.AbstractConfigurationAdministrator;
import org.eclipse.scada.ca.common.ConfigurationImpl;
import org.eclipse.scada.ca.jdbc.internal.Entry;
import org.eclipse.scada.ca.jdbc.internal.JdbcStorageDAO;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdministratorImpl
extends AbstractConfigurationAdministrator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationAdministratorImpl.class);
    private static final int INITIAL_CFG_SIZE = Integer.getInteger("org.eclipse.scada.ca.jdbc.initialConfigurationHashSize", 4);
    private final boolean disableIntern = Boolean.getBoolean("org.eclipse.scada.ca.jdbc.disableIntern");
    private final JdbcStorageDAO jdbcStorageDAO;

    public ConfigurationAdministratorImpl(BundleContext context, JdbcStorageDAO jdbcStorageDAO) {
        super(context);
        this.jdbcStorageDAO = jdbcStorageDAO;
    }

    public synchronized void start() throws Exception {
        super.start();
        this.initialLoad();
    }

    protected synchronized void initialLoad() throws SQLException {
        logger.debug("Starting initial load");
        List<String> factoryIds = this.jdbcStorageDAO.listFactories();
        HashMap factories = new HashMap(factoryIds.size());
        for (String string : factoryIds) {
            List<Entry> result = this.jdbcStorageDAO.loadFactory(string);
            logger.debug("Loaded {} initial entries for factory {}", (Object)result.size(), (Object)string);
            for (Entry entry : result) {
                HashMap<String, String> cfg;
                if (entry.getFactoryId() == null || entry.getConfigurationId() == null || entry.getKey() == null) continue;
                HashMap factory = (HashMap)factories.get(entry.getFactoryId());
                if (factory == null) {
                    factory = new HashMap();
                    factories.put(this.intern(entry.getFactoryId()), factory);
                }
                if ((cfg = (HashMap<String, String>)factory.get(entry.getConfigurationId())) == null) {
                    cfg = new HashMap<String, String>(INITIAL_CFG_SIZE);
                    factory.put(entry.getConfigurationId(), cfg);
                }
                String value = this.intern(entry.getValue());
                String key = this.intern(entry.getKey());
                cfg.put(key, value);
            }
        }
        for (Map.Entry entry : factories.entrySet()) {
            ArrayList<ConfigurationImpl> configurations = new ArrayList<ConfigurationImpl>(((Map)entry.getValue()).size());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ConfigurationImpl cfg = new ConfigurationImpl((String)entry2.getKey(), (String)entry.getKey(), (Map)entry2.getValue());
                configurations.add(cfg);
            }
            this.addStoredFactory((String)entry.getKey(), configurations.toArray(new ConfigurationImpl[configurations.size()]));
        }
    }

    private String intern(String string) {
        if (this.disableIntern) {
            return string;
        }
        if (string == null) {
            return null;
        }
        return string.intern();
    }

    protected synchronized void performDeleteConfiguration(UserInformation userInformation, String factoryId, String configurationId, AbstractConfigurationAdministrator.ConfigurationFuture future) throws Exception {
        this.jdbcStorageDAO.deleteConfiguration(factoryId, configurationId);
        this.changeConfiguration(userInformation, factoryId, configurationId, null, future);
    }

    protected synchronized void performPurge(UserInformation userInformation, String factoryId, AbstractConfigurationAdministrator.PurgeFuture future) {
        logger.info("Purging: {}", (Object)factoryId);
        HashSet<String> done = new HashSet<String>();
        for (Entry entry : this.jdbcStorageDAO.purgeFactory(factoryId)) {
            if (!done.add(entry.getConfigurationId())) continue;
            AbstractConfigurationAdministrator.ConfigurationFuture subFuture = new AbstractConfigurationAdministrator.ConfigurationFuture();
            this.changeConfiguration(userInformation, factoryId, entry.getConfigurationId(), null, subFuture);
            future.addChild((NotifyFuture)subFuture);
        }
        logger.info("Purging: {} complete", (Object)factoryId);
        future.setComplete();
    }

    protected synchronized void performStoreConfiguration(UserInformation userInformation, String factoryId, String configurationId, Map<String, String> properties, boolean fullSet, AbstractConfigurationAdministrator.ConfigurationFuture future) throws Exception {
        Map<String, String> resultProperties = this.jdbcStorageDAO.storeConfiguration(factoryId, configurationId, properties, fullSet);
        this.changeConfiguration(userInformation, factoryId, configurationId, resultProperties, future);
    }
}

