/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common;

import java.util.Date;
import java.util.Map;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.utils.AbstractBaseConfiguration;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.AbstractConfigurableMasterHandlerImpl;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractCommonHandlerImpl
extends AbstractConfigurableMasterHandlerImpl {
    private final String sourceName;

    public AbstractCommonHandlerImpl(String configurationId, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker, String prefix, String factoryId) {
        super(configurationId, poolTracker, priority, caTracker, prefix, factoryId);
        this.sourceName = configurationId;
    }

    protected abstract void processDataUpdate(Map<String, Object> var1, DataItemValue.Builder var2) throws Exception;

    protected Event.EventBuilder createEventBuilder() {
        Event.EventBuilder builder = Event.create();
        builder.sourceTimestamp(new Date());
        builder.entryTimestamp(new Date());
        this.injectEventAttributes(builder);
        return builder;
    }

    protected void injectEventAttributes(Event.EventBuilder builder) {
        builder.attribute(Event.Fields.SOURCE, (Object)this.sourceName);
        builder.attributes(this.eventAttributes);
    }

    public void dataUpdate(Map<String, Object> context, DataItemValue.Builder builder) {
        if (builder == null) {
            return;
        }
        try {
            this.processDataUpdate(context, builder);
        }
        catch (Throwable e) {
            builder.setAttribute(this.getPrefixed("error", Activator.getStringInterner()), Variant.TRUE);
            builder.setAttribute(this.getPrefixed("error.message", Activator.getStringInterner()), Variant.valueOf((Object)e.getMessage()));
        }
    }

    public static class AbstractConfiguration
    extends AbstractBaseConfiguration {
        private final AbstractCommonHandlerImpl commonHandler;
        private final EventProcessor eventProcessor;

        public AbstractConfiguration(AbstractConfiguration currentConfiguration, AbstractCommonHandlerImpl commonHandler, EventProcessor eventProcessor) {
            super((AbstractBaseConfiguration)currentConfiguration);
            this.commonHandler = commonHandler;
            this.eventProcessor = eventProcessor;
        }

        protected void injectEventAttributes(Event.EventBuilder builder) {
            this.commonHandler.injectEventAttributes(builder);
        }

        protected void sendEvent(Event event) {
            this.eventProcessor.publishEvent(event);
        }
    }
}

