/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.block;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.WriteRequest;
import org.eclipse.scada.da.master.WriteRequestResult;
import org.eclipse.scada.da.master.common.AbstractCommonHandlerImpl;
import org.eclipse.scada.da.master.common.block.Messages;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;

public class BlockHandlerImpl
extends AbstractCommonHandlerImpl {
    private boolean active = false;
    private String note = null;
    private final EventProcessor eventProcessor;
    private String user;
    private Long timestamp;
    private final Variant source;
    private final String attrBlocked;
    private final String attrActive;
    private final String attrUser;
    private final String attrNote;
    private final String attrTimestamp;

    public BlockHandlerImpl(String configurationId, EventProcessor eventProcessor, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(configurationId, poolTracker, priority, caTracker, "org.eclipse.scada.da.master.common.block", "org.eclipse.scada.da.master.common.block");
        this.source = Variant.valueOf((Object)configurationId);
        this.eventProcessor = eventProcessor;
        this.attrBlocked = this.getPrefixed("blocked", Activator.getStringInterner());
        this.attrActive = this.getPrefixed("active", Activator.getStringInterner());
        this.attrNote = this.getPrefixed("note", Activator.getStringInterner());
        this.attrUser = this.getPrefixed("user", Activator.getStringInterner());
        this.attrTimestamp = this.getPrefixed("timestamp", Activator.getStringInterner());
    }

    @Override
    protected void processDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) throws Exception {
        this.injectAttributes(builder);
    }

    public WriteRequestResult processWrite(WriteRequest request) {
        WriteRequest testRequest;
        boolean active = this.active;
        WriteRequestResult result = super.processWrite(request);
        if (active && !(testRequest = result != null ? new WriteRequest(result.getValue(), result.getAttributes(), request.getOperationParameters()) : request).isEmpty()) {
            this.publishEvent(testRequest.getOperationParameters() != null ? testRequest.getOperationParameters().getUserInformation() : UserInformation.ANONYMOUS, this.makeNote(), this.makeString(testRequest), "BLOCK");
            return this.createBlockedResult();
        }
        return result;
    }

    private String makeNote() {
        if (this.note == null || this.note.isEmpty()) {
            return Messages.getString("BlockHandlerImpl.WriteErrorNoReason");
        }
        return String.format(Messages.getString("BlockHandlerImpl.WriteError"), this.note);
    }

    private String makeString(WriteRequest result) {
        StringBuilder sb = new StringBuilder();
        if (result.getValue() != null) {
            sb.append(result.getValue().toString());
        }
        if (result.getAttributes() != null && !result.getAttributes().isEmpty()) {
            for (Map.Entry entry : result.getAttributes().entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey());
                sb.append("->");
                sb.append(entry.getValue());
            }
        }
        return sb.toString();
    }

    private WriteRequestResult createBlockedResult() {
        return new WriteRequestResult((Throwable)new OperationException(Messages.getString("BlockHandlerImpl.OperationException")));
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.note = this.updateValue(userInformation, Messages.getString("BlockHandlerImpl.UpdateConfiguration.note"), cfg.getString("note", null), this.note);
        this.active = this.updateValue(userInformation, Messages.getString("BlockHandlerImpl.UpdateConfiguration.active"), cfg.getBoolean("active", false), this.active);
        this.user = this.updateValue(userInformation, Messages.getString("BlockHandlerImpl.UpdateConfiguration.user"), cfg.getString("user", null), this.user);
        this.timestamp = cfg.getLong("timestamp");
        this.reprocess();
    }

    protected <T> T updateValue(UserInformation userInformation, String message, T newValue, T oldValue) {
        if (newValue == oldValue) {
            return newValue;
        }
        if (newValue != null && newValue.equals(oldValue)) {
            return newValue;
        }
        this.publishEvent(userInformation, message, newValue, "CFG");
        return newValue;
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        builder.setAttribute(this.attrBlocked, Variant.valueOf((boolean)this.active));
        builder.setAttribute(this.attrActive, Variant.valueOf((boolean)this.active));
        builder.setAttribute(this.attrNote, Variant.valueOf((Object)this.note));
        builder.setAttribute(this.attrUser, Variant.valueOf((Object)this.user));
        builder.setAttribute(this.attrTimestamp, Variant.valueOf((Object)this.timestamp));
    }

    protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        String name;
        HashMap<String, String> data = new HashMap<String, String>();
        Variant active = attributes.get("active");
        Variant factor = attributes.get("note");
        if (active != null && !active.isNull()) {
            data.put("active", active.asString());
        }
        if (factor != null && !factor.isNull()) {
            data.put("note", factor.asString());
        }
        if (operationParameters != null && operationParameters.getUserInformation() != null && (name = operationParameters.getUserInformation().getName()) != null) {
            data.put("user", name);
        }
        data.put("timestamp", "" + System.currentTimeMillis());
        return this.updateConfiguration(data, attributes, false, operationParameters);
    }

    protected void publishEvent(UserInformation user, String message, Object value, String eventType) {
        Event.EventBuilder builder = this.createEvent(user, message, value);
        if (eventType != null) {
            builder.attribute(Event.Fields.EVENT_TYPE, Variant.valueOf((Object)eventType));
        }
        this.eventProcessor.publishEvent(builder.build());
    }

    protected Event.EventBuilder createEvent(UserInformation user, String message, Object value) {
        Event.EventBuilder builder = this.createEventBuilder();
        builder.attribute(Event.Fields.SOURCE, this.source);
        builder.attribute(Event.Fields.MONITOR_TYPE, (Object)"BLOCK");
        if (user != null && user.getName() != null) {
            builder.attribute(Event.Fields.ACTOR_TYPE, (Object)"USER");
            builder.attribute(Event.Fields.ACTOR_NAME, (Object)user.getName());
        }
        if (message != null) {
            builder.attribute(Event.Fields.MESSAGE, (Object)message);
        }
        if (value != null) {
            builder.attribute(Event.Fields.VALUE, value);
        }
        return builder;
    }
}

