/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.internal;

import com.google.common.collect.Interner;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.block.BlockHandlerFactoryImpl;
import org.eclipse.scada.da.master.common.manual.ManualHandlerFactoryImpl;
import org.eclipse.scada.da.master.common.marker.MarkerHandlerFactoryImpl;
import org.eclipse.scada.da.master.common.negate.NegateHandlerFactoryImpl;
import org.eclipse.scada.da.master.common.round.RoundHandlerFactoryImpl;
import org.eclipse.scada.da.master.common.scale.ScaleHandlerFactoryImpl;
import org.eclipse.scada.da.master.common.sum.CommonSumHandlerFactoryImpl;
import org.eclipse.scada.utils.interner.InternerHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Activator instance;
    private EventProcessor eventProcessor;
    private ObjectPoolTracker<MasterItem> poolTracker;
    private ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker;
    private final Collection<AbstractServiceConfigurationFactory<?>> factories = new LinkedList();
    private Interner<String> stringInterner;

    public void start(BundleContext context) throws Exception {
        instance = this;
        this.stringInterner = InternerHelper.makeInterner((String)"org.eclipse.scada.da.master.common.stringInterner", (String)"java");
        this.eventProcessor = new EventProcessor(context);
        this.eventProcessor.open();
        this.poolTracker = new ObjectPoolTracker(context, MasterItem.class);
        this.poolTracker.open();
        this.caTracker = new ServiceTracker(context, ConfigurationAdministrator.class, null);
        this.caTracker.open();
        AbstractServiceConfigurationFactory factory = new CommonSumHandlerFactoryImpl(context, this.poolTracker);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "An attribute sum handler");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "da.master.handler.sum");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
        factory = new ScaleHandlerFactoryImpl(context, this.poolTracker, this.caTracker, 500);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A local scaling master handler");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.scale.input");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
        factory = new NegateHandlerFactoryImpl(context, this.poolTracker, this.caTracker, 501);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A local negate master handler");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.negate.input");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
        factory = new ManualHandlerFactoryImpl(context, this.eventProcessor, this.poolTracker, this.caTracker, 1000);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A local manual override master handler");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.manual");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
        factory = new BlockHandlerFactoryImpl(context, this.eventProcessor, this.poolTracker, this.caTracker, Integer.MIN_VALUE);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A blocking operation handler");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.master.common.block");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
        factory = new RoundHandlerFactoryImpl(context, this.poolTracker, this.caTracker, 502);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A rounding operation handler");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.round");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
        factory = new MarkerHandlerFactoryImpl(context, this.eventProcessor, this.poolTracker, this.caTracker, 100);
        properties = new Hashtable();
        ((Dictionary)properties).put("service.description", "A handler which allows to injects a marker");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.master.common.marker");
        context.registerService(ConfigurationFactory.class, (Object)factory, properties);
        this.factories.add(factory);
    }

    public static Interner<String> getStringInterner() {
        return Activator.instance.stringInterner;
    }

    public void stop(BundleContext context) throws Exception {
        for (AbstractServiceConfigurationFactory<?> factory : this.factories) {
            factory.dispose();
        }
        this.poolTracker.close();
        this.poolTracker = null;
        this.caTracker.close();
        this.caTracker = null;
        this.eventProcessor.close();
        this.eventProcessor = null;
        instance = null;
    }
}

