/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.round;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.AbstractCommonHandlerImpl;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;

public class RoundHandlerImpl
extends AbstractCommonHandlerImpl {
    private boolean active = false;
    private RoundType type = RoundType.NONE;
    private String error = null;
    private final String attrValueOriginal;
    private final String attrActive = this.getPrefixed("active", Activator.getStringInterner());
    private final String attrType = this.getPrefixed("type", Activator.getStringInterner());
    private final String attrError = this.getPrefixed("error", Activator.getStringInterner());

    public RoundHandlerImpl(String configurationId, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(configurationId, poolTracker, priority, caTracker, "org.eclipse.scada.da.round", "org.eclipse.scada.da.round");
        this.attrValueOriginal = this.getPrefixed("value.original", Activator.getStringInterner());
    }

    @Override
    protected void processDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) throws Exception {
        this.injectAttributes(builder);
        builder.setAttribute(this.attrValueOriginal, builder.getValue());
        Variant val = builder.getValue();
        if (val == null || val.isNull()) {
            return;
        }
        builder.setValue(this.handleDataUpdate(builder.getValue()));
    }

    private Variant handleDataUpdate(Variant value) {
        if (!this.active || this.type == RoundType.NONE || value == null || value.isNull()) {
            return value;
        }
        switch (this.type) {
            case CEIL: {
                return Variant.valueOf((double)Math.ceil(value.asDouble(null)));
            }
            case FLOOR: {
                return Variant.valueOf((double)Math.floor(value.asDouble(null)));
            }
            case ROUND: {
                return Variant.valueOf((double)Math.round(value.asDouble(null)));
            }
        }
        return value;
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.active = cfg.getBoolean("active", false);
        try {
            this.type = RoundType.valueOf(cfg.getString("type", "NONE"));
            this.error = null;
        }
        catch (IllegalArgumentException e) {
            this.type = RoundType.NONE;
            this.error = e.getMessage();
        }
        catch (NullPointerException e) {
            this.type = RoundType.NONE;
            this.error = e.getMessage();
        }
        this.reprocess();
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        builder.setAttribute(this.attrActive, this.active ? Variant.TRUE : Variant.FALSE);
        if (this.type != null && this.type != RoundType.NONE) {
            builder.setAttribute(this.attrType, Variant.valueOf((Object)this.type.toString()));
        }
        if (this.error != null) {
            builder.setAttribute(this.attrError, Variant.valueOf((Object)this.error));
        }
    }

    protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        Variant active = attributes.get("active");
        Variant type = attributes.get("type");
        if (active != null && !active.isNull()) {
            data.put("active", active.asString());
        }
        if (type != null && !type.isNull()) {
            data.put("type", type.asString());
        }
        return this.updateConfiguration(data, attributes, false, operationParameters);
    }

    private static enum RoundType {
        NONE,
        CEIL,
        FLOOR,
        ROUND;

    }
}

