/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.sum;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.AbstractMasterHandlerImpl;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.sum.Entry;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;

public class CommonSumHandler
extends AbstractMasterHandlerImpl {
    private volatile List<Entry> entries = new LinkedList<Entry>();

    public CommonSumHandler(ObjectPoolTracker<MasterItem> poolTracker) {
        super(poolTracker);
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        String[] tags;
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        boolean debug = cfg.getBoolean("debug", false);
        LinkedList<Entry> entries = new LinkedList<Entry>();
        String[] stringArray = tags = cfg.getStringChecked("tag", "'tag' must be set").split(", ?");
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            String prefix = cfg.getString(String.format("tag.%s.prefix", tag), "osgi.source");
            String suffix = cfg.getString(String.format("tag.%s.suffix", tag));
            String pattern = cfg.getString(String.format("tag.%s.pattern", tag));
            entries.add(new Entry(tag, prefix, suffix, pattern, debug));
            ++n2;
        }
        this.entries = entries;
        this.reprocess();
    }

    public void dataUpdate(Map<String, Object> context, DataItemValue.Builder builder) {
        this.convertSource(builder);
        for (Entry entry : this.entries) {
            entry.start(context, builder);
        }
        for (Map.Entry entry : builder.getAttributes().entrySet()) {
            Variant pValue = (Variant)entry.getValue();
            String name = (String)entry.getKey();
            for (Entry entry2 : this.entries) {
                entry2.check(name, pValue);
            }
        }
        for (Entry entry : this.entries) {
            entry.end(context, builder);
        }
    }

    private void convertSource(DataItemValue.Builder builder) {
        for (Entry entry : this.entries) {
            entry.convertSource(builder);
        }
    }
}

