/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.sum;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.utils.str.StringHelper;

public class Entry {
    private final String tag;
    private final String attributeName;
    private final String attributeCountName;
    private final String suffix;
    private final Pattern pattern;
    private final String contextAttribute;
    private final String prefix;
    private final boolean debug;
    private Set<Object> contextSet;
    private int matches;

    public Entry(String tag, String prefix, String suffix, String pattern, boolean debug) {
        this.tag = tag;
        this.prefix = prefix;
        this.attributeName = String.format("%s.%s", this.prefix, this.tag);
        this.attributeCountName = String.valueOf(this.attributeName) + ".count";
        this.contextAttribute = String.valueOf(this.tag) + ".set";
        this.suffix = suffix == null ? "." + tag : suffix;
        this.pattern = Entry.makePattern(pattern);
        this.debug = debug;
    }

    public void convertSource(DataItemValue.Builder builder) {
        Variant sourceValue = (Variant)builder.getAttributes().remove(this.tag);
        if (sourceValue != null) {
            builder.setAttribute(this.attributeName, sourceValue);
        }
        if ((sourceValue = (Variant)builder.getAttributes().remove(this.attributeCountName)) != null && this.debug) {
            builder.setAttribute(String.format("%s.%s.count", this.prefix, this.tag), sourceValue);
        }
        if ((sourceValue = (Variant)builder.getAttributes().remove(String.valueOf(this.tag) + ".items")) != null && this.debug) {
            builder.setAttribute(String.format("%s.%s.items", this.prefix, this.tag), sourceValue);
        }
    }

    public void start(Map<String, Object> context, DataItemValue.Builder builder) {
        this.contextSet = Entry.getContextSet(context, this.contextAttribute);
        if (this.debug) {
            builder.setAttribute(String.valueOf(this.prefix) + ".before", Variant.valueOf((Object)StringHelper.join(this.contextSet, (String)",")));
        }
        this.matches = 0;
    }

    public void check(String name, Variant value) {
        if (this.matches(name, value) && !this.contextSet.contains(name)) {
            ++this.matches;
            this.contextSet.add(name);
        }
    }

    public void end(Map<String, Object> context, DataItemValue.Builder builder) {
        if (this.debug) {
            builder.setAttribute(String.valueOf(this.prefix) + ".after", Variant.valueOf((Object)StringHelper.join(this.contextSet, (String)",")));
        }
        builder.setAttribute(this.tag, Variant.valueOf((this.matches != 0 ? 1 : 0) != 0));
        if (this.debug) {
            builder.setAttribute(String.valueOf(this.tag) + ".count", Variant.valueOf((int)this.matches));
        }
        this.contextSet = null;
    }

    private boolean matches(String name, Variant value) {
        if (value == null || name == null) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.matcher(name).matches() : !name.endsWith(this.suffix)) {
            return false;
        }
        return value.asBoolean();
    }

    private static Set<Object> getContextSet(Map<String, Object> context, String contextAttribute) {
        Object o = context.get(contextAttribute);
        if (o instanceof Set) {
            return (Set)o;
        }
        HashSet<Object> set = new HashSet<Object>();
        context.put(contextAttribute, set);
        return set;
    }

    private static Pattern makePattern(String string) {
        if (string == null) {
            return null;
        }
        return Pattern.compile(string);
    }
}

