/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.client;

import com.google.common.net.InetAddresses;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.client.Client;
import org.eclipse.neoscada.protocol.iec60870.client.ClientModule;
import org.eclipse.neoscada.protocol.iec60870.client.ConnectionStateListener;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConnectClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AutoConnectClient.class);
    private static final AtomicLong counter = new AtomicLong();
    private final ConnectionStateListener listener = new ConnectionStateListener(){

        @Override
        public void disconnected(Throwable error) {
            AutoConnectClient.this.handleDisconnected(error);
        }

        @Override
        public void connected(Channel channel) {
            AutoConnectClient.this.handleConnected();
        }
    };
    private final StateListener stateListener;
    private volatile ScheduledExecutorService executor;
    private final ProtocolOptions options;
    private final InetSocketAddress address;
    private Client client;
    private final ModulesFactory modulesFactory;

    public AutoConnectClient(String host, int port, ProtocolOptions options, ModulesFactory modulesFactory, StateListener stateListener) {
        this.executor = new ScheduledExportedExecutorService(AutoConnectClient.makeName(host, port), 1);
        this.stateListener = stateListener;
        this.options = options;
        this.modulesFactory = modulesFactory;
        this.address = this.makeAddress(host, port);
        this.triggerConnect(0L);
    }

    private InetSocketAddress makeAddress(String host, int port) {
        try {
            return new InetSocketAddress(InetAddresses.forString((String)host), port);
        }
        catch (IllegalArgumentException e) {
            return InetSocketAddress.createUnresolved(host, port);
        }
    }

    private synchronized void triggerConnect(long delay) {
        logger.debug("Trigger reconnect: {} ms delay", (Object)delay);
        if (delay > 0L) {
            this.fireState(State.SLEEPING);
        }
        if (this.executor == null) {
            return;
        }
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                AutoConnectClient.this.processConnect();
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookup() {
        this.fireState(State.LOOKUP);
        final InetSocketAddress address = new InetSocketAddress(this.address.getHostString(), this.address.getPort());
        if (address.isUnresolved()) {
            UnresolvedAddressException e = new UnresolvedAddressException();
            this.handleDisconnected(e);
        }
        AutoConnectClient autoConnectClient = this;
        synchronized (autoConnectClient) {
            if (this.executor == null) {
                return;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AutoConnectClient.this.createClient(address);
                }
            });
        }
    }

    protected synchronized void createClient(InetSocketAddress resolvedAddress) {
        this.fireState(State.CONNECTING);
        logger.debug("Creating new client instance");
        if (this.executor == null) {
            return;
        }
        this.client = new Client(resolvedAddress, this.listener, this.options, this.modulesFactory.createModules());
        this.client.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCommand(Object command) {
        Client client;
        AutoConnectClient autoConnectClient = this;
        synchronized (autoConnectClient) {
            client = this.client;
        }
        if (client != null) {
            client.writeCommand(command);
            return true;
        }
        return false;
    }

    private void fireState(State state) {
        this.fireState(state, null);
    }

    private void fireState(final State state, final Throwable e) {
        logger.info("State changed: {}", (Object)state);
        if (e != null) {
            logger.info("State failure", e);
        }
        if (this.stateListener != null && this.executor != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AutoConnectClient.this.stateListener.stateChanged(state, e);
                }
            });
        }
    }

    @Override
    public void close() {
        logger.debug("Closing instance");
        ScheduledExecutorService service = this.executor;
        this.executor = null;
        try {
            this.closeClient();
        }
        finally {
            service.shutdown();
        }
    }

    private synchronized void closeClient() {
        logger.debug("Closing client");
        if (this.client == null) {
            return;
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close client", (Throwable)e);
        }
        this.client = null;
    }

    private static String makeName(String host, int port) {
        return String.format("%s/%s/%s", host, port, counter.incrementAndGet());
    }

    protected synchronized void handleConnected() {
        this.fireState(State.CONNECTED);
    }

    private synchronized void handleDisconnected(Throwable error) {
        logger.info("handleDisconnected");
        this.closeClient();
        this.fireState(State.DISCONNECTED, error);
        this.triggerConnect(10000L);
    }

    public synchronized void reconnect() {
        logger.warn("Reconnect requested");
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close client", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void processConnect() {
        if (this.executor == null) {
            return;
        }
        if (this.address.isUnresolved()) {
            this.lookup();
        } else {
            this.createClient(this.address);
        }
    }

    public void requestStartData() {
        if (this.client != null) {
            try {
                this.client.requestStartData();
            }
            catch (Exception e) {
                logger.warn("Failed to send StartDT", (Throwable)e);
            }
        }
    }

    public static interface ModulesFactory {
        public List<ClientModule> createModules();
    }

    public static enum State {
        SLEEPING,
        DISCONNECTED,
        LOOKUP,
        CONNECTING,
        CONNECTED;

    }

    public static interface StateListener {
        public void stateChanged(State var1, Throwable var2);
    }
}

