/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public final class Locks {
    private Locks() {
    }

    public static Locked lock(final Lock lock) {
        lock.lock();
        return new Locked(){

            @Override
            public void close() {
                lock.unlock();
            }
        };
    }

    public static <T> T call(Lock lock, Supplier<T> call) {
        lock.lock();
        try {
            T t = call.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static interface Locked
    extends AutoCloseable {
        @Override
        public void close();
    }
}

