/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.osgi;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.packagedrone.utils.osgi.FactoryTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SimpleFactoryTracker<S, T>
extends FactoryTracker<S, T> {
    private final Function<ServiceReference<S>, String> idFunc;
    private final BiFunction<ServiceReference<S>, S, T> serviceFunc;

    public SimpleFactoryTracker(BundleContext context, Class<S> serviceClass, Function<ServiceReference<S>, String> idFunc, BiFunction<ServiceReference<S>, S, T> serviceFunc) {
        super(context, serviceClass);
        this.idFunc = idFunc;
        this.serviceFunc = serviceFunc;
    }

    public SimpleFactoryTracker(BundleContext context, Class<S> serviceClass, Function<ServiceReference<S>, String> idFunc, Function<S, T> serviceFunc) {
        this(context, serviceClass, idFunc, (ServiceReference<S> ref, S service) -> serviceFunc.apply(service));
    }

    public SimpleFactoryTracker(BundleContext context, Class<S> serviceClass, String idKey, Function<S, T> serviceFunc) {
        this(context, serviceClass, (ServiceReference<S> ref) -> SimpleFactoryTracker.getString(ref, idKey), (ServiceReference<S> ref, S service) -> serviceFunc.apply(service));
    }

    @Override
    protected String getFactoryId(ServiceReference<S> ref) {
        return this.idFunc.apply(ref);
    }

    @Override
    protected T mapService(ServiceReference<S> reference, S service) {
        return this.serviceFunc.apply(reference, service);
    }
}

