/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.oscar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OscarWriter {
    private final Map<String, Map<String, Map<String, String>>> data;
    private final Map<String, Set<String>> ignoreData;

    public OscarWriter(Map<String, Map<String, Map<String, String>>> data, Map<String, Set<String>> ignoreData) {
        this.data = data;
        this.ignoreData = ignoreData;
    }

    public void write(File file) throws FileNotFoundException, IOException {
        this.write(new FileOutputStream(file));
    }

    public void write(OutputStream targetStream) throws IOException {
        try (ZipOutputStream zout = new ZipOutputStream(targetStream);){
            ZipEntry entry = new ZipEntry("data.json");
            zout.putNextEntry(entry);
            OscarWriter.writeData(this.data, zout);
            zout.closeEntry();
            if (this.ignoreData != null && !this.ignoreData.isEmpty()) {
                entry = new ZipEntry("ignoreFields.json");
                zout.putNextEntry(entry);
                OscarWriter.writeIgnoreData(this.ignoreData, zout);
                zout.closeEntry();
            }
        }
    }

    public static void writeData(Map<String, Map<String, Map<String, String>>> data, OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        Gson g = new GsonBuilder().setPrettyPrinting().create();
        g.toJson(data, (Appendable)writer);
        writer.flush();
    }

    public static void writeIgnoreData(Map<String, Set<String>> ignoreData, OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        Gson g = new GsonBuilder().setPrettyPrinting().create();
        g.toJson(ignoreData, (Appendable)writer);
        writer.flush();
    }
}

