/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.input;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.data.Operation;
import org.eclipse.scada.ca.ui.jobs.DiffJob;
import org.eclipse.scada.ca.ui.jobs.LoadFactoryJob;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class FactoryEditorInput
implements IEditorInput {
    private final String connectionUri;
    private final String factoryId;
    private final ConnectionService connectionService;

    public FactoryEditorInput(ConnectionService connectionService, String factoryId) {
        this.connectionService = connectionService;
        this.connectionUri = connectionService.getConnection().getConnectionInformation().toString();
        this.factoryId = factoryId;
    }

    public String getConnectionUri() {
        return this.connectionUri;
    }

    public String toString() {
        return this.factoryId;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.toString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.toString();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public LoadFactoryJob createLoadJob() {
        return new LoadFactoryJob(this.connectionService, this.factoryId);
    }

    public Job createDeleteJob(Collection<String> items) {
        LinkedList<DiffEntry> diffEntries = new LinkedList<DiffEntry>();
        for (String configurationId : items) {
            diffEntries.add(new DiffEntry(this.factoryId, configurationId, Operation.DELETE, null, null, null));
        }
        return new DiffJob("Delete configurations", (org.eclipse.scada.core.connection.provider.ConnectionService)this.connectionService, diffEntries);
    }

    public Job createCreateJob(String configurationId) {
        DiffEntry entry = new DiffEntry(this.factoryId, configurationId, Operation.ADD, null, Collections.emptyMap(), null);
        return new DiffJob("Create configuration", (org.eclipse.scada.core.connection.provider.ConnectionService)this.connectionService, entry);
    }
}

