/**
 * Copyright (c) 2014 IBH SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBH SYSTEMS GmbH - initial API and implementation
 */
package org.eclipse.scada.da.server.component.parser.factory.configuration.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.scada.da.server.component.parser.factory.configuration.ParserPackage;

import org.eclipse.scada.da.server.component.parser.factory.configuration.util.ParserAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ParserItemProviderAdapterFactory extends ParserAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender
{
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This helps manage the child creation extenders.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager ( ConfigurationEditPlugin.INSTANCE, ParserPackage.eNS_URI );

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ParserItemProviderAdapterFactory ()
    {
        supportedTypes.add ( IEditingDomainItemProvider.class );
        supportedTypes.add ( IStructuredItemContentProvider.class );
        supportedTypes.add ( ITreeItemContentProvider.class );
        supportedTypes.add ( IItemLabelProvider.class );
        supportedTypes.add ( IItemPropertySource.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.Component} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComponentItemProvider componentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.Component}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createComponentAdapter ()
    {
        if ( componentItemProvider == null )
        {
            componentItemProvider = new ComponentItemProvider ( this );
        }

        return componentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.FileInput} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FileInputItemProvider fileInputItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.FileInput}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFileInputAdapter ()
    {
        if ( fileInputItemProvider == null )
        {
            fileInputItemProvider = new FileInputItemProvider ( this );
        }

        return fileInputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.PlainText} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PlainTextItemProvider plainTextItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.PlainText}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPlainTextAdapter ()
    {
        if ( plainTextItemProvider == null )
        {
            plainTextItemProvider = new PlainTextItemProvider ( this );
        }

        return plainTextItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.UrlInput} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UrlInputItemProvider urlInputItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.UrlInput}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUrlInputAdapter ()
    {
        if ( urlInputItemProvider == null )
        {
            urlInputItemProvider = new UrlInputItemProvider ( this );
        }

        return urlInputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.SinglePattern} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SinglePatternItemProvider singlePatternItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.SinglePattern}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSinglePatternAdapter ()
    {
        if ( singlePatternItemProvider == null )
        {
            singlePatternItemProvider = new SinglePatternItemProvider ( this );
        }

        return singlePatternItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.ValueDescriptor} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ValueDescriptorItemProvider valueDescriptorItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.ValueDescriptor}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createValueDescriptorAdapter ()
    {
        if ( valueDescriptorItemProvider == null )
        {
            valueDescriptorItemProvider = new ValueDescriptorItemProvider ( this );
        }

        return valueDescriptorItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.AttributeValue} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AttributeValueItemProvider attributeValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.AttributeValue}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAttributeValueAdapter ()
    {
        if ( attributeValueItemProvider == null )
        {
            attributeValueItemProvider = new AttributeValueItemProvider ( this );
        }

        return attributeValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.MainGroupField} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MainGroupFieldItemProvider mainGroupFieldItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.MainGroupField}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMainGroupFieldAdapter ()
    {
        if ( mainGroupFieldItemProvider == null )
        {
            mainGroupFieldItemProvider = new MainGroupFieldItemProvider ( this );
        }

        return mainGroupFieldItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.StringGroupField} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StringGroupFieldItemProvider stringGroupFieldItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.StringGroupField}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createStringGroupFieldAdapter ()
    {
        if ( stringGroupFieldItemProvider == null )
        {
            stringGroupFieldItemProvider = new StringGroupFieldItemProvider ( this );
        }

        return stringGroupFieldItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.NumericGroupField} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NumericGroupFieldItemProvider numericGroupFieldItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.NumericGroupField}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createNumericGroupFieldAdapter ()
    {
        if ( numericGroupFieldItemProvider == null )
        {
            numericGroupFieldItemProvider = new NumericGroupFieldItemProvider ( this );
        }

        return numericGroupFieldItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.SplitTable} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SplitTableItemProvider splitTableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.SplitTable}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSplitTableAdapter ()
    {
        if ( splitTableItemProvider == null )
        {
            splitTableItemProvider = new SplitTableItemProvider ( this );
        }

        return splitTableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.StringTransformer} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StringTransformerItemProvider stringTransformerItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.StringTransformer}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createStringTransformerAdapter ()
    {
        if ( stringTransformerItemProvider == null )
        {
            stringTransformerItemProvider = new StringTransformerItemProvider ( this );
        }

        return stringTransformerItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.MqttInput} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MqttInputItemProvider mqttInputItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.MqttInput}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMqttInputAdapter ()
    {
        if ( mqttInputItemProvider == null )
        {
            mqttInputItemProvider = new MqttInputItemProvider ( this );
        }

        return mqttInputItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.BooleanValueConverter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BooleanValueConverterItemProvider booleanValueConverterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.BooleanValueConverter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBooleanValueConverterAdapter ()
    {
        if ( booleanValueConverterItemProvider == null )
        {
            booleanValueConverterItemProvider = new BooleanValueConverterItemProvider ( this );
        }

        return booleanValueConverterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.DefaultValueConverter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DefaultValueConverterItemProvider defaultValueConverterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.DefaultValueConverter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDefaultValueConverterAdapter ()
    {
        if ( defaultValueConverterItemProvider == null )
        {
            defaultValueConverterItemProvider = new DefaultValueConverterItemProvider ( this );
        }

        return defaultValueConverterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.DoubleValueConverter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DoubleValueConverterItemProvider doubleValueConverterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.DoubleValueConverter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDoubleValueConverterAdapter ()
    {
        if ( doubleValueConverterItemProvider == null )
        {
            doubleValueConverterItemProvider = new DoubleValueConverterItemProvider ( this );
        }

        return doubleValueConverterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.component.parser.factory.configuration.BooleanSetValueConverter} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BooleanSetValueConverterItemProvider booleanSetValueConverterItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.component.parser.factory.configuration.BooleanSetValueConverter}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBooleanSetValueConverterAdapter ()
    {
        if ( booleanSetValueConverterItemProvider == null )
        {
            booleanSetValueConverterItemProvider = new BooleanSetValueConverterItemProvider ( this );
        }

        return booleanSetValueConverterItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders ()
    {
        return childCreationExtenderManager.getChildCreationExtenders ();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Collection<?> getNewChildDescriptors ( Object object, EditingDomain editingDomain )
    {
        return childCreationExtenderManager.getNewChildDescriptors ( object, editingDomain );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ResourceLocator getResourceLocator ()
    {
        return childCreationExtenderManager;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose ()
    {
        if ( componentItemProvider != null )
            componentItemProvider.dispose ();
        if ( fileInputItemProvider != null )
            fileInputItemProvider.dispose ();
        if ( plainTextItemProvider != null )
            plainTextItemProvider.dispose ();
        if ( urlInputItemProvider != null )
            urlInputItemProvider.dispose ();
        if ( singlePatternItemProvider != null )
            singlePatternItemProvider.dispose ();
        if ( valueDescriptorItemProvider != null )
            valueDescriptorItemProvider.dispose ();
        if ( attributeValueItemProvider != null )
            attributeValueItemProvider.dispose ();
        if ( mainGroupFieldItemProvider != null )
            mainGroupFieldItemProvider.dispose ();
        if ( stringGroupFieldItemProvider != null )
            stringGroupFieldItemProvider.dispose ();
        if ( numericGroupFieldItemProvider != null )
            numericGroupFieldItemProvider.dispose ();
        if ( splitTableItemProvider != null )
            splitTableItemProvider.dispose ();
        if ( stringTransformerItemProvider != null )
            stringTransformerItemProvider.dispose ();
        if ( mqttInputItemProvider != null )
            mqttInputItemProvider.dispose ();
        if ( booleanValueConverterItemProvider != null )
            booleanValueConverterItemProvider.dispose ();
        if ( defaultValueConverterItemProvider != null )
            defaultValueConverterItemProvider.dispose ();
        if ( doubleValueConverterItemProvider != null )
            doubleValueConverterItemProvider.dispose ();
        if ( booleanSetValueConverterItemProvider != null )
            booleanSetValueConverterItemProvider.dispose ();
    }

}
