/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StaticStateInformation;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.dataitem.details.extra.part.AbstractBaseDraw2DDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.extra.part.Messages;
import org.eclipse.scada.da.client.dataitem.details.extra.part.VariantEntryDialog;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.swt.widgets.Composite;

public class ManualOverride
extends AbstractBaseDraw2DDetailsPart {
    private Label pvValue;
    private Label mvValue;
    private Label rvValue;
    private RoundedRectangle rvRect;
    private RoundedRectangle mvRect;
    private RoundedRectangle pvRect;
    private PolylineConnection p2rConnection;
    private PolylineConnection m2rConnection;
    private Variant manualValue;
    private RoundedRectangle rmvRect;
    private Label rmvValue;
    private RoundedRectangle rpvRect;
    private Label rpvValue;
    private PolylineConnection rp2pConnection;
    private PolylineConnection rm2pConnection;
    private LocalResourceManager resourceManager;
    private Figure rmvFigure;
    private Figure rpvFigure;
    private StyleBlinker pvRectBlinker;
    private StyleBlinker rvRectBlinker;
    private StateStyler pvRectStyler;
    private StateStyler rvRectStyler;

    @Override
    public void createPart(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        super.createPart(parent);
    }

    @Override
    public IFigure createMain() {
        LayeredPane root = new LayeredPane();
        Layer figureLayer = new Layer();
        figureLayer.setLayoutManager((LayoutManager)new FlowLayout());
        ConnectionLayer connectionLayer = new ConnectionLayer();
        connectionLayer.setAntialias(1);
        Figure figure = new Figure();
        figureLayer.add((IFigure)figure);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.horizontalSpacing = 50;
        gridLayout.verticalSpacing = 50;
        figure.setLayoutManager((LayoutManager)gridLayout);
        Figure rpvFigure = this.createRPV();
        Figure pvFigure = this.createPV();
        Figure rmvFigure = this.createRMV();
        Figure mvFigure = this.createMV();
        Figure rvFigure = this.createRV();
        figure.add((IFigure)rpvFigure, (Object)new GridData(2, 2, true, true, 1, 1));
        figure.add((IFigure)pvFigure, (Object)new GridData(2, 2, true, true, 1, 2));
        figure.add((IFigure)rvFigure, (Object)new GridData(2, 2, true, true, 1, 3));
        figure.add((IFigure)rmvFigure, (Object)new GridData(2, 2, true, true, 1, 1));
        figure.add((IFigure)mvFigure, (Object)new GridData(2, 2, true, true, 1, 1));
        figure.add((IFigure)new Figure(), (Object)new GridData(2, 2, true, true, 1, 1));
        this.p2rConnection = this.createConnection((IFigure)this.pvRect, (IFigure)this.rvRect);
        connectionLayer.add((IFigure)this.p2rConnection);
        this.m2rConnection = this.createConnection((IFigure)this.mvRect, (IFigure)this.rvRect);
        connectionLayer.add((IFigure)this.m2rConnection);
        this.rp2pConnection = this.createConnection((IFigure)this.rpvRect, (IFigure)this.pvRect);
        connectionLayer.add((IFigure)this.rp2pConnection);
        this.rm2pConnection = this.createConnection((IFigure)this.rmvRect, (IFigure)this.pvRect);
        connectionLayer.add((IFigure)this.rm2pConnection);
        root.add((IFigure)figureLayer);
        root.add((IFigure)connectionLayer);
        return root;
    }

    private CallbackHandler makeDisplayCallback() {
        return new DisplayCallbackHandler(this.shell, "Configure Manual Override", "Confirmation required for configuring manual override");
    }

    private PolylineConnection createConnection(IFigure source, IFigure target) {
        PolylineConnection c = new PolylineConnection();
        ChopboxAnchor sourceAnchor = new ChopboxAnchor(source);
        ChopboxAnchor targetAnchor = new ChopboxAnchor(target);
        c.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        return c;
    }

    private Figure createRV() {
        Figure rvFigure = new Figure();
        rvFigure.setLayoutManager((LayoutManager)new BorderLayout());
        Label label = new Label(Messages.ManualOverride_ResetValue_Label);
        label.setBorder((Border)new MarginBorder(10));
        rvFigure.add((IFigure)label, (Object)BorderLayout.RIGHT);
        this.rvRect = new RoundedRectangle();
        this.rvRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.rvValue = new Label();
        this.rvRect.setBackgroundColor(ColorConstants.lightGray);
        this.rvValue.setBorder((Border)new MarginBorder(10));
        this.rvRect.add((IFigure)this.rvValue, (Object)BorderLayout.CENTER);
        this.rvRectBlinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                ManualOverride.this.rvRect.setBackgroundColor(style.background);
                ManualOverride.this.rvRect.setForegroundColor(style.foreground);
                ManualOverride.this.rvRect.setFont(style.font);
            }
        };
        this.rvRectStyler = new StateStyler((StyleHandler)this.rvRectBlinker);
        rvFigure.add((IFigure)this.rvRect, (Object)BorderLayout.CENTER);
        return rvFigure;
    }

    private Figure createRMV() {
        this.rmvFigure = new Figure();
        this.rmvFigure.setLayoutManager((LayoutManager)new BorderLayout());
        Label label = new Label(Messages.ManualOverride_RemoteManualvalue_Label);
        label.setBorder((Border)new MarginBorder(10));
        this.rmvFigure.add((IFigure)label, (Object)BorderLayout.LEFT);
        this.rmvRect = new RoundedRectangle();
        this.rmvRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.rmvValue = new Label();
        this.rmvValue.setBorder((Border)new MarginBorder(10));
        this.rmvRect.setBackgroundColor(ColorConstants.lightGray);
        this.rmvRect.add((IFigure)this.rmvValue, (Object)BorderLayout.CENTER);
        this.rmvRect.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ManualOverride.this.rmvRect.setLineWidth(2);
            }

            public void mouseExited(MouseEvent me) {
                ManualOverride.this.rmvRect.setLineWidth(1);
            }
        });
        this.rmvRect.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
                ManualOverride.this.handleSetRemoteManualValue();
            }

            public void mousePressed(MouseEvent me) {
                ManualOverride.this.setRemoteManualState(true);
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        this.rmvFigure.add((IFigure)this.rmvRect, (Object)BorderLayout.CENTER);
        return this.rmvFigure;
    }

    protected void setRemoteManualState(boolean state) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("remote.manual.active", Variant.valueOf((boolean)state));
        this.writeAttributes(attributes);
    }

    protected void handleSetRemoteManualValue() {
        Variant var = null;
        try {
            var = (Variant)this.value.getAttributes().get("remote.manual.value");
        }
        catch (Exception e) {
            var = null;
        }
        Variant value = new VariantEntryDialog(this.shell, var).getValue();
        if (value != null) {
            HashMap<String, Variant> attributes = new HashMap<String, Variant>();
            attributes.put("remote.manual.value", value);
            this.writeAttributes(attributes);
        }
    }

    private Figure createMV() {
        Figure mvFigure = new Figure();
        mvFigure.setLayoutManager((LayoutManager)new BorderLayout());
        Label label = new Label(Messages.ManualOverride_LocalManualValue_Label);
        label.setBorder((Border)new MarginBorder(10));
        mvFigure.add((IFigure)label, (Object)BorderLayout.LEFT);
        this.mvRect = new RoundedRectangle();
        this.mvRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.mvValue = new Label();
        this.mvValue.setBorder((Border)new MarginBorder(10));
        this.mvRect.setBackgroundColor(ColorConstants.lightGray);
        this.mvRect.add((IFigure)this.mvValue, (Object)BorderLayout.CENTER);
        this.mvRect.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ManualOverride.this.mvRect.setLineWidth(2);
            }

            public void mouseExited(MouseEvent me) {
                ManualOverride.this.mvRect.setLineWidth(1);
            }
        });
        this.mvRect.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
                ManualOverride.this.manualValue = null;
                ManualOverride.this.switchToManual();
            }

            public void mousePressed(MouseEvent me) {
                ManualOverride.this.switchToManual();
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        mvFigure.add((IFigure)this.mvRect, (Object)BorderLayout.CENTER);
        return mvFigure;
    }

    protected void switchToManual() {
        if (this.manualValue == null) {
            this.enterManualValue();
            if (this.manualValue == null) {
                return;
            }
        }
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("org.eclipse.scada.da.manual.value", this.manualValue);
        this.writeAttributes(attributes);
    }

    protected void writeAttributes(Map<String, Variant> attributes) {
        this.item.writeAtrtibutes(attributes, null, this.makeDisplayCallback());
    }

    private Figure createRPV() {
        this.rpvFigure = new Figure();
        this.rpvFigure.setLayoutManager((LayoutManager)new BorderLayout());
        Label label = new Label(Messages.ManualOverride_RemoteProcessValue_Label);
        label.setBorder((Border)new MarginBorder(10));
        this.rpvFigure.add((IFigure)label, (Object)BorderLayout.LEFT);
        this.rpvRect = new RoundedRectangle();
        this.rpvRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.rpvValue = new Label();
        this.rpvValue.setBorder((Border)new MarginBorder(10));
        this.rpvRect.setBackgroundColor(ColorConstants.lightGray);
        this.rpvRect.add((IFigure)this.rpvValue, (Object)BorderLayout.CENTER);
        this.rpvFigure.add((IFigure)this.rpvRect, (Object)BorderLayout.CENTER);
        this.rpvRect.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ManualOverride.this.rpvRect.setLineWidth(2);
            }

            public void mouseExited(MouseEvent me) {
                ManualOverride.this.rpvRect.setLineWidth(1);
            }
        });
        this.rpvRect.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                ManualOverride.this.setRemoteManualState(false);
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        return this.rpvFigure;
    }

    private Figure createPV() {
        Figure pvFigure = new Figure();
        pvFigure.setLayoutManager((LayoutManager)new BorderLayout());
        Label label = new Label(Messages.ManualOverride_ProcessValue_Label);
        label.setBorder((Border)new MarginBorder(10));
        pvFigure.add((IFigure)label, (Object)BorderLayout.LEFT);
        this.pvRect = new RoundedRectangle();
        this.pvRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.pvValue = new Label();
        this.pvValue.setBorder((Border)new MarginBorder(10));
        this.pvRect.setBackgroundColor(ColorConstants.lightGray);
        this.pvRect.add((IFigure)this.pvValue, (Object)BorderLayout.CENTER);
        this.pvRectBlinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                ManualOverride.this.pvRect.setBackgroundColor(style.background);
                ManualOverride.this.pvRect.setForegroundColor(style.foreground);
                ManualOverride.this.pvRect.setFont(style.font);
            }
        };
        this.pvRectStyler = new StateStyler((StyleHandler)this.pvRectBlinker);
        pvFigure.add((IFigure)this.pvRect, (Object)BorderLayout.CENTER);
        this.pvRect.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ManualOverride.this.pvRect.setLineWidth(2);
            }

            public void mouseExited(MouseEvent me) {
                ManualOverride.this.pvRect.setLineWidth(1);
            }
        });
        this.pvRect.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                ManualOverride.this.switchToProcess();
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        return pvFigure;
    }

    protected void enterManualValue() {
        VariantEntryDialog dlg = this.value != null ? new VariantEntryDialog(this.shell, this.value.getValue()) : new VariantEntryDialog(this.shell);
        this.manualValue = dlg.getValue();
    }

    protected void switchToProcess() {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("org.eclipse.scada.da.manual.value", Variant.NULL);
        this.item.writeAtrtibutes(attributes, null, this.makeDisplayCallback());
    }

    @Override
    public void dispose() {
        this.pvRectStyler.dispose();
        this.rvRectStyler.dispose();
        this.rvRectBlinker.dispose();
        this.pvRectBlinker.dispose();
        this.resourceManager.dispose();
        super.dispose();
    }

    protected void updateRemote() {
        Boolean remoteManual = this.value.isAttribute("remote.manual.active");
        Variant remoteProcessValue = (Variant)this.value.getAttributes().get("remote.manual.value.original");
        Variant remoteManualValue = (Variant)this.value.getAttributes().get("remote.manual.value");
        this.setRemoteVisible(remoteManual != null);
        if (remoteManual == null) {
            this.setConnectionState(this.rp2pConnection, false);
            this.setConnectionState(this.rm2pConnection, false);
        } else if (remoteManual.booleanValue()) {
            this.setConnectionState(this.rp2pConnection, false);
            this.setConnectionState(this.rm2pConnection, true);
        } else {
            this.setConnectionState(this.rp2pConnection, true);
            this.setConnectionState(this.rm2pConnection, false);
        }
        if (remoteManualValue != null) {
            this.rmvValue.setText(remoteManualValue.toString());
        }
        if (remoteProcessValue != null) {
            this.rpvValue.setText(remoteProcessValue.toString());
        }
    }

    private void setRemoteVisible(boolean visible) {
        this.rmvFigure.setVisible(visible);
        this.rpvFigure.setVisible(visible);
        this.rp2pConnection.setVisible(visible);
        this.rm2pConnection.setVisible(visible);
    }

    private boolean isLocalManual() {
        return this.value.isAttribute("org.eclipse.scada.da.manual.active", false);
    }

    private boolean isRemoteManual() {
        return this.value.isAttribute("remote.manual.active", false);
    }

    private void updateLocalManualValue() {
        if (this.manualValue == null) {
            this.manualValue = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.manual.value");
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.value == null) {
            return;
        }
        this.updateRemote();
        this.updateLocalManualValue();
        this.rvValue.setText(this.value.getValue().toString());
        if (this.isRemoteManual()) {
            this.pvRectStyler.style((StateInformation)new StaticStateInformation(StateInformation.State.MANUAL));
        } else {
            this.pvRectStyler.style(null);
        }
        if (this.isManual()) {
            this.rvRectStyler.style((StateInformation)new StaticStateInformation(StateInformation.State.MANUAL));
        } else {
            this.rvRectStyler.style(null);
        }
        Variant manualValue = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.manual.value");
        Variant processValue = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.manual.value.original");
        Variant processError = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.manual.error.original");
        if (processError == null) {
            processError = Variant.FALSE;
        }
        if (manualValue != null) {
            this.mvValue.setText(manualValue.toString());
        } else {
            this.mvValue.setText(Messages.ManualOverride_None);
        }
        if (this.isLocalManual()) {
            this.setConnectionState(this.p2rConnection, false);
            this.setConnectionState(this.m2rConnection, true);
            if (processValue != null) {
                this.pvValue.setText(processValue.toString());
            } else {
                this.pvValue.setText(Messages.ManualOverride_None);
            }
            if (processError.asBoolean()) {
                this.pvRect.setBackgroundColor(ColorConstants.red);
            }
        } else {
            this.setConnectionState(this.p2rConnection, true);
            this.setConnectionState(this.m2rConnection, false);
            this.pvValue.setText(this.value.getValue().toString());
        }
    }

    protected void setConnectionState(PolylineConnection connection, boolean state) {
        PolygonDecoration dec = new PolygonDecoration();
        dec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        connection.setLineStyle(state ? 1 : 3);
        connection.setLineWidth(state ? 2 : 1);
        connection.setTargetDecoration((RotatableDecoration)(state ? dec : null));
    }

    @Override
    protected boolean isAvailable() {
        return this.hasAttribute("org.eclipse.scada.da.manual.active");
    }
}

