/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.client.dataitem.details.extra.part.Messages;
import org.eclipse.scada.da.ui.common.ValueType;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VariantEntryDialog
extends TitleAreaDialog {
    private Variant value;
    private Text convertText;
    private Text valueText;
    private Combo valueTypeSelect;
    private Variant variant;

    public VariantEntryDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
    }

    public VariantEntryDialog(Shell parentShell, Variant variant) {
        this(parentShell);
        this.variant = variant;
    }

    public Variant getValue() {
        if (this.open() != 0) {
            return null;
        }
        return this.value;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.setMessage(Messages.VariantEntryDialog_Dialog_Message, 1);
        this.setTitle(Messages.VariantEntryDialog_Dialog_Title);
        this.getShell().setText(Messages.VariantEntryDialog_Dialog_Title);
        this.createEntryArea((Composite)control);
        return control;
    }

    protected Control createEntryArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText(Messages.VariantEntryDialog_Value_Label);
        this.valueText = new Text(comp, 2050);
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariantEntryDialog.this.dialogChanged();
            }
        });
        new Label(comp, 0).setText(Messages.VariantEntryDialog_Type_Label);
        this.valueTypeSelect = new Combo(comp, 12);
        this.valueTypeSelect.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ValueType[] valueTypeArray = ValueType.values();
        int n = valueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValueType vt = valueTypeArray[n2];
            this.valueTypeSelect.add(vt.label(), vt.ordinal());
            ++n2;
        }
        this.valueTypeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariantEntryDialog.this.dialogChanged();
            }
        });
        try {
            if (!this.variant.isNull()) {
                this.valueTypeSelect.select(ValueType.fromVariantType((VariantType)this.variant.getType()).ordinal());
            } else {
                this.valueTypeSelect.select(ValueType.STRING.ordinal());
            }
        }
        catch (Exception e) {
            this.valueTypeSelect.select(ValueType.STRING.ordinal());
        }
        new Label(comp, 0).setText(Messages.VariantEntryDialog_Text_Value);
        this.convertText = new Text(comp, 2058);
        this.convertText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (this.variant != null) {
            try {
                this.valueText.setText(this.variant.asString());
                this.valueText.selectAll();
            }
            catch (NullValueException nullValueException) {
                // empty catch block
            }
        }
        return comp;
    }

    protected void dialogChanged() {
        this.setValueText(Messages.VariantEntryDialog_NoValue, true);
        this.value = null;
        int idx = this.valueTypeSelect.getSelectionIndex();
        try {
            ValueType[] valueTypeArray = ValueType.values();
            int n = valueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueType vt = valueTypeArray[n2];
                if (vt.ordinal() == idx) {
                    this.value = vt.convertTo(this.valueText.getText());
                }
                ++n2;
            }
        }
        catch (NotConvertableException e) {
            this.updateStatus(String.valueOf(Messages.VariantEntryDialog_ErrorMessage) + e.getMessage());
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.value != null) {
            this.setValueText(this.value.toString(), false);
        } else {
            this.setValueText(String.valueOf(Messages.VariantEntryDialog_NoConverter) + idx, true);
        }
        this.updateStatus(null);
    }

    private void setValueText(String stringValue, boolean error) {
        this.convertText.setText(stringValue);
    }

    private void updateStatus(String message) {
        this.setMessage(message, 3);
    }
}

