/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.data;

import java.io.Serializable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.ui.IMemento;

public class Item
implements Serializable {
    private static final long serialVersionUID = 7384306434115724744L;
    private Type type;
    private String connectionString;
    private String id;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Item() {
    }

    public Item(String connectionString, String id, Type type) {
        this.connectionString = connectionString;
        this.id = id;
        this.type = type == null ? Type.URI : type;
    }

    public Item(Item item) {
        this.connectionString = item.connectionString;
        this.id = item.id;
        this.type = item.type;
    }

    public static Item adaptTo(Object o) {
        if (o instanceof Item) {
            return (Item)o;
        }
        if (o instanceof IAdaptable) {
            return (Item)((IAdaptable)o).getAdapter(Item.class);
        }
        return (Item)Platform.getAdapterManager().getAdapter(o, Item.class);
    }

    public static Item loadFrom(IMemento memento) {
        if (memento == null) {
            return null;
        }
        String itemId = memento.getString("item.id");
        String connectionUri = memento.getString("connection.uri");
        String typeStr = memento.getString("type");
        Type type = typeStr != null ? Type.valueOf(typeStr) : Type.URI;
        if (itemId == null || connectionUri == null || type == null) {
            return null;
        }
        return new Item(connectionUri, itemId, type);
    }

    public void saveTo(IMemento memento) {
        if (memento == null) {
            return;
        }
        memento.putString("item.id", this.id);
        memento.putString("connection.uri", this.connectionString);
        memento.putString("type", this.type.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connectionString == null ? 0 : this.connectionString.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        if (this.connectionString == null ? other.connectionString != null : !this.connectionString.equals(other.connectionString)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String toString() {
        return String.format("[%s: %s#%s]", new Object[]{this.type, this.connectionString, this.id});
    }

    public String toLabel() {
        if (this.type == Type.URI) {
            try {
                ConnectionInformation info = ConnectionInformation.fromURI((String)this.connectionString);
                return String.format("[%s: %s#%s]", new Object[]{this.type, info.toMaskedString(), this.id});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.format("[%s: %s#%s]", new Object[]{this.type, this.connectionString, this.id});
    }

    public static enum Type {
        URI,
        ID;

    }
}

