/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.daemon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;

public class Starter {
    private static final String PROP_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String FILE_PROTO = "file:";
    private static final String PATTERN_BUNDLES_SPLITTER = ", *";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private Framework framework;
    private File bundleRoot;
    private HashMap<String, String> properties;
    private boolean debug;
    private boolean started;
    private Formatter logger;
    private static String NL = System.getProperty("line.separator", "\n");

    public void start(String[] args) throws Exception {
        ServiceLoader<FrameworkFactory> loader;
        Iterator<FrameworkFactory> i;
        if (this.started) {
            return;
        }
        this.started = true;
        this.debug = Boolean.getBoolean("org.eclipse.scada.utils.osgi.daemon.debug");
        if (this.debug) {
            this.logger = new Formatter(System.out);
        }
        if (!(i = (loader = ServiceLoader.load(FrameworkFactory.class)).iterator()).hasNext()) {
            throw new IllegalStateException("No FrameworkFactory found!");
        }
        FrameworkFactory factory = i.next();
        this.properties = new HashMap();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] toks = arg.split("=", 2);
            if (toks.length >= 2) {
                this.properties.put(toks[0], toks[1]);
            } else {
                this.properties.put(toks[0], null);
            }
            ++n2;
        }
        this.properties.put("org.osgi.framework.startlevel.beginning", "4");
        this.framework = factory.newFramework(this.properties);
        this.framework.init();
        try {
            this.loadStartBundles(this.framework, this.properties);
        }
        catch (Exception e) {
            this.framework.stop();
            throw e;
        }
        this.framework.start();
    }

    protected void log(String format, Throwable e, Object ... args) {
        if (this.logger != null) {
            this.logger.format(String.valueOf(format) + NL, args);
            e.printStackTrace(System.out);
        }
    }

    protected void log(String format, Object ... args) {
        if (this.logger != null) {
            this.logger.format(String.valueOf(format) + NL, args);
        }
    }

    public void stop() throws Exception {
        if (this.started) {
            this.framework.stop();
            this.framework.waitForStop(0L);
            this.started = false;
        }
    }

    private String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        return System.getProperty(key);
    }

    private void loadStartBundles(Framework framework, Map<String, String> properties) {
        String bundles = this.getProperty(PROP_OSGI_BUNDLES);
        if (bundles == null || bundles.isEmpty()) {
            return;
        }
        Map<String, Bundle> best = this.getBestBundles(this.findRoot());
        String[] stringArray = bundles.split(PATTERN_BUNDLES_SPLITTER);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            this.processBundle(framework, bundle, best);
            ++n2;
        }
    }

    private File findRoot() {
        if (this.bundleRoot != null) {
            return this.bundleRoot;
        }
        this.bundleRoot = this.makeRoot();
        if (this.bundleRoot == null) {
            throw new IllegalStateException(String.format("Unable to determine bundle root. Specify '%s' manually.", PROP_OSGI_INSTALL_AREA));
        }
        this.log("Bundle root: %s", this.bundleRoot);
        return this.bundleRoot;
    }

    private File makeRoot() {
        String frameworkPath;
        String installArea = this.getProperty(PROP_OSGI_INSTALL_AREA);
        if (installArea != null && !installArea.isEmpty()) {
            if (installArea.startsWith(FILE_PROTO)) {
                installArea = installArea.substring(FILE_PROTO.length());
            }
            File base = new File(installArea);
            if ((base = new File(base, "plugins")).isDirectory()) {
                return base;
            }
        }
        if ((frameworkPath = this.getProperty("osgi.framework")) != null && !frameworkPath.isEmpty()) {
            if (frameworkPath.startsWith(FILE_PROTO)) {
                frameworkPath = frameworkPath.substring(FILE_PROTO.length());
            }
            File fw = new File(frameworkPath.substring(FILE_PROTO.length()));
            return fw.getParentFile();
        }
        return null;
    }

    public Map<String, Bundle> getBestBundles(File root) {
        HashMap<String, Bundle> result = new HashMap<String, Bundle>();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle;
            Throwable throwable;
            Serializable manifest;
            File file = fileArray[n2];
            if (file.isDirectory() && ((File)(manifest = new File(file, "META-INF" + File.separator + "MANIFEST.MF"))).isFile() && ((File)manifest).canRead()) {
                try {
                    throwable = null;
                    Object var9_14 = null;
                    try (FileInputStream in = new FileInputStream(file);){
                        bundle = this.readFromManifest("reference:file:plugins/" + file.getName() + "/", new Manifest(in));
                        if (bundle != null) {
                            this.addToResult(result, bundle);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    this.log("Failed to check: %s", e, file);
                }
            }
            if (file.isFile() && file.getName().endsWith(".jar")) {
                try {
                    manifest = null;
                    throwable = null;
                    try (JarInputStream jis = new JarInputStream(new FileInputStream(file));){
                        Manifest m = jis.getManifest();
                        bundle = this.readFromManifest("reference:file:plugins/" + file.getName(), m);
                        if (bundle != null) {
                            this.addToResult(result, bundle);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (manifest == null) {
                            manifest = throwable3;
                        } else if (manifest != throwable3) {
                            ((Throwable)manifest).addSuppressed(throwable3);
                        }
                        throw manifest;
                    }
                }
                catch (Exception e) {
                    this.log("Failed to check: %s", e, file);
                }
            }
            ++n2;
        }
        return result;
    }

    private Bundle readFromManifest(String location, Manifest m) throws IOException {
        String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
        if (!(sn instanceof String)) {
            return null;
        }
        String version = m.getMainAttributes().getValue("Bundle-Version");
        if (!(version instanceof String)) {
            return null;
        }
        String symName = sn;
        symName = symName.split(";", 2)[0];
        return new Bundle(symName, new Version(version), location);
    }

    private void addToResult(Map<String, Bundle> result, Bundle bundle) {
        Bundle old = result.get(bundle.getSymbolicName());
        if (old == null || old.getVersion().compareTo(bundle.getVersion()) < 0) {
            this.log("New best bundle: %s - %s", bundle.getSymbolicName(), bundle.getVersion());
            result.put(bundle.getSymbolicName(), bundle);
        }
    }

    private void processBundle(Framework framework, String bundle, Map<String, Bundle> best) {
        Bundle bb;
        String[] toks = bundle.split("@", 2);
        String sn = toks[0];
        Integer startLevel = null;
        boolean autoStart = false;
        if (toks.length > 1 && !toks[1].isEmpty()) {
            String[] toks2 = toks[1].split(":", 2);
            try {
                if (toks2.length > 1) {
                    startLevel = Integer.parseInt(toks2[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (toks2.length > 1) {
                autoStart = "start".equals(toks2[toks2.length - 1]);
            }
        }
        if ((bb = best.get(sn)) == null) {
            this.log("Unable to find start bundle: %s", sn);
            return;
        }
        try {
            this.log("Initial install for %s", sn);
            org.osgi.framework.Bundle theBundle = this.findBundle(bb);
            if (theBundle == null) {
                theBundle = framework.getBundleContext().installBundle(bb.getLocation());
            }
            if (startLevel != null) {
                this.log("Setting start level: %s", startLevel);
                BundleStartLevel bsl = (BundleStartLevel)theBundle.adapt(BundleStartLevel.class);
                bsl.setStartLevel(startLevel.intValue());
            }
            if (autoStart) {
                this.log("Auto start", new Object[0]);
                theBundle.start();
            }
        }
        catch (BundleException e) {
            this.log("Failed to install initial bundle: %s", e, toks[0]);
        }
    }

    private org.osgi.framework.Bundle findBundle(Bundle bb) {
        org.osgi.framework.Bundle[] bundleArray = this.framework.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.osgi.framework.Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals(bb.getSymbolicName())) {
                return b;
            }
            ++n2;
        }
        return null;
    }

    private static class Bundle {
        private final String symbolicName;
        private final Version version;
        private final String location;

        public Bundle(String symbolicName, Version version, String location) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.location = location;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

