/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870;

import java.io.Serializable;
import java.util.TimeZone;
import org.eclipse.neoscada.protocol.iec60870.ASDUAddressType;
import org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType;
import org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;

public class ProtocolOptions {
    private int timeout1 = 15000;
    private int timeout2 = 10000;
    private int timeout3 = 20000;
    private ASDUAddressType adsuAddressType = ASDUAddressType.SIZE_2;
    private InformationObjectAddressType informationObjectAddressType = InformationObjectAddressType.SIZE_3;
    private CauseOfTransmissionType causeOfTransmissionType = CauseOfTransmissionType.SIZE_2;
    private final short maxSequenceNumber = Short.MAX_VALUE;
    private short maxUnacknowledged = (short)15;
    private short acknowledgeWindow = (short)10;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private final String timeZoneId;
    private final boolean ignoreDaylightSavingTime;

    public ProtocolOptions(int timeout1, int timeout2, int timeout3, ASDUAddressType adsuAddressType, InformationObjectAddressType informationObjectAddressType, CauseOfTransmissionType causeOfTransmissionType, short maxUnacknowledged, short acknowledgeWindow, TimeZone timeZone, boolean ignoreDaylightSavingTime) {
        this.timeout1 = timeout1;
        this.timeout2 = timeout2;
        this.timeout3 = timeout3;
        this.adsuAddressType = adsuAddressType;
        this.informationObjectAddressType = informationObjectAddressType;
        this.causeOfTransmissionType = causeOfTransmissionType;
        this.maxUnacknowledged = maxUnacknowledged;
        this.acknowledgeWindow = acknowledgeWindow;
        this.timeZone = timeZone;
        this.timeZoneId = timeZone != null ? timeZone.getID() : null;
        this.ignoreDaylightSavingTime = ignoreDaylightSavingTime;
    }

    public int getTimeout1() {
        return this.timeout1;
    }

    public int getTimeout2() {
        return this.timeout2;
    }

    public int getTimeout3() {
        return this.timeout3;
    }

    public int getAcknowledgeWindow() {
        return this.acknowledgeWindow;
    }

    public int getMaxUnacknowledged() {
        return this.maxUnacknowledged;
    }

    public short getMaxSequenceNumber() {
        return Short.MAX_VALUE;
    }

    public ASDUAddressType getAdsuAddressType() {
        return this.adsuAddressType;
    }

    public InformationObjectAddressType getInformationObjectAddressType() {
        return this.informationObjectAddressType;
    }

    public CauseOfTransmissionType getCauseOfTransmissionType() {
        return this.causeOfTransmissionType;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isIgnoreDaylightSavingTime() {
        return this.ignoreDaylightSavingTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.acknowledgeWindow;
        result = 31 * result + (this.adsuAddressType == null ? 0 : this.adsuAddressType.hashCode());
        result = 31 * result + (this.causeOfTransmissionType == null ? 0 : this.causeOfTransmissionType.hashCode());
        result = 31 * result + (this.ignoreDaylightSavingTime ? 1231 : 1237);
        result = 31 * result + (this.informationObjectAddressType == null ? 0 : this.informationObjectAddressType.hashCode());
        result = 31 * result + Short.MAX_VALUE;
        result = 31 * result + this.maxUnacknowledged;
        result = 31 * result + (this.timeZoneId == null ? 0 : this.timeZoneId.hashCode());
        result = 31 * result + this.timeout1;
        result = 31 * result + this.timeout2;
        result = 31 * result + this.timeout3;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolOptions other = (ProtocolOptions)obj;
        if (this.acknowledgeWindow != other.acknowledgeWindow) {
            return false;
        }
        if (this.adsuAddressType != other.adsuAddressType) {
            return false;
        }
        if (this.causeOfTransmissionType != other.causeOfTransmissionType) {
            return false;
        }
        if (this.ignoreDaylightSavingTime != other.ignoreDaylightSavingTime) {
            return false;
        }
        if (this.informationObjectAddressType != other.informationObjectAddressType) {
            return false;
        }
        if (Short.MAX_VALUE != other.maxSequenceNumber) {
            return false;
        }
        if (this.maxUnacknowledged != other.maxUnacknowledged) {
            return false;
        }
        if (this.timeZoneId == null ? other.timeZoneId != null : !this.timeZoneId.equals(other.timeZoneId)) {
            return false;
        }
        if (this.timeout1 != other.timeout1) {
            return false;
        }
        if (this.timeout2 != other.timeout2) {
            return false;
        }
        return this.timeout3 == other.timeout3;
    }

    public static class Builder
    extends AbstractPropertyChange
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String PROP_TIMEOUT1 = "timeout1";
        public static final String PROP_TIMEOUT2 = "timeout2";
        public static final String PROP_TIMEOUT3 = "timeout3";
        public static final String PROP_MAX_UNACKNOWLEDGED = "maxUnacknowledged";
        public static final String PROP_ACKNOWLEDGE_WINDOW = "acknowledgeWindow";
        public static final String PROP_ASDU_ADDRESS_TYPE = "adsuAddressType";
        public static final String PROP_INFORMATION_OBJECT_ADDRESS_TYPE = "informationObjectAddressType";
        public static final String PROP_CAUSE_OF_TRANSMISSION_TYPE = "causeOfTransmissionType";
        public static final String PROP_TIME_ZONE = "timeZone";
        public static final String PROP_IGNORE_DAYLIGHT_SAVING_TIME = "ignoreDaylightSavingTime";
        private int timeout1 = 15000;
        private int timeout2 = 10000;
        private int timeout3 = 20000;
        private ASDUAddressType adsuAddressType = ASDUAddressType.SIZE_2;
        private InformationObjectAddressType informationObjectAddressType = InformationObjectAddressType.SIZE_3;
        private CauseOfTransmissionType causeOfTransmissionType = CauseOfTransmissionType.SIZE_2;
        private final short maxSequenceNumber = Short.MAX_VALUE;
        private short maxUnacknowledged = (short)15;
        private short acknowledgeWindow = (short)10;
        private TimeZone timeZone = TimeZone.getTimeZone("UTC");
        private boolean ignoreDaylightSavingTime;

        public Builder() {
        }

        public Builder(ProtocolOptions other) {
            this.timeout1 = other.timeout1;
            this.timeout2 = other.timeout2;
            this.timeout3 = other.timeout3;
            this.adsuAddressType = other.adsuAddressType;
            this.informationObjectAddressType = other.informationObjectAddressType;
            this.causeOfTransmissionType = other.causeOfTransmissionType;
            this.acknowledgeWindow = other.acknowledgeWindow;
            this.maxUnacknowledged = other.maxUnacknowledged;
            this.timeZone = other.timeZone;
            this.ignoreDaylightSavingTime = other.ignoreDaylightSavingTime;
        }

        public ProtocolOptions build() {
            this.validate();
            return new ProtocolOptions(this.timeout1, this.timeout2, this.timeout3, this.adsuAddressType, this.informationObjectAddressType, this.causeOfTransmissionType, this.maxUnacknowledged, this.acknowledgeWindow, this.timeZone, this.ignoreDaylightSavingTime);
        }

        public void validate() {
            this.validate(PROP_MAX_UNACKNOWLEDGED, this.maxUnacknowledged, 1, Short.MAX_VALUE - 1);
            this.validate(PROP_ACKNOWLEDGE_WINDOW, this.acknowledgeWindow, 1, this.maxUnacknowledged - 1);
        }

        private void validate(String parameter, int value, int start, int end) {
            if (value < start || value > end) {
                throw new IllegalStateException(String.format("'%s' must be between %s (inclusive) and %s (inclusive), but is %s", parameter, start, end, value));
            }
        }

        public int getTimeout1() {
            return this.timeout1;
        }

        public void setTimeout1(int timeout1) {
            this.timeout1 = timeout1;
            this.firePropertyChange(PROP_TIMEOUT1, this.timeout1, this.timeout1);
        }

        public int getTimeout2() {
            return this.timeout2;
        }

        public void setTimeout2(int timeout2) {
            this.timeout2 = timeout2;
            this.firePropertyChange(PROP_TIMEOUT2, this.timeout2, this.timeout2);
        }

        public int getTimeout3() {
            return this.timeout3;
        }

        public void setTimeout3(int timeout3) {
            this.timeout3 = timeout3;
            this.firePropertyChange(PROP_TIMEOUT3, this.timeout3, this.timeout3);
        }

        public short getAcknowledgeWindow() {
            return this.acknowledgeWindow;
        }

        public void setAcknowledgeWindow(short acknowledgeWindow) {
            this.acknowledgeWindow = acknowledgeWindow;
            this.firePropertyChange(PROP_ACKNOWLEDGE_WINDOW, this.acknowledgeWindow, this.acknowledgeWindow);
        }

        public short getMaxUnacknowledged() {
            return this.maxUnacknowledged;
        }

        public void setMaxUnacknowledged(short maxUnacknowledged) {
            this.maxUnacknowledged = maxUnacknowledged;
            this.firePropertyChange(PROP_MAX_UNACKNOWLEDGED, this.maxUnacknowledged, this.maxUnacknowledged);
        }

        public ASDUAddressType getAdsuAddressType() {
            return this.adsuAddressType;
        }

        public void setAdsuAddressType(ASDUAddressType adsuAddressType) {
            this.adsuAddressType = adsuAddressType;
            this.firePropertyChange(PROP_ASDU_ADDRESS_TYPE, (Object)this.adsuAddressType, (Object)this.adsuAddressType);
        }

        public InformationObjectAddressType getInformationObjectAddressType() {
            return this.informationObjectAddressType;
        }

        public void setInformationObjectAddressType(InformationObjectAddressType informationObjectAddressType) {
            this.informationObjectAddressType = informationObjectAddressType;
            this.firePropertyChange(PROP_INFORMATION_OBJECT_ADDRESS_TYPE, (Object)this.informationObjectAddressType, (Object)this.informationObjectAddressType);
        }

        public CauseOfTransmissionType getCauseOfTransmissionType() {
            return this.causeOfTransmissionType;
        }

        public void setCauseOfTransmissionType(CauseOfTransmissionType causeOfTransmissionType) {
            this.causeOfTransmissionType = causeOfTransmissionType;
            this.firePropertyChange(PROP_CAUSE_OF_TRANSMISSION_TYPE, (Object)this.causeOfTransmissionType, (Object)this.causeOfTransmissionType);
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            TimeZone oldTimeZone = this.timeZone;
            this.timeZone = timeZone == null ? TimeZone.getTimeZone("UTC") : timeZone;
            this.firePropertyChange(PROP_TIME_ZONE, oldTimeZone, this.timeZone);
        }

        public void setIgnoreDaylightSavingTime(boolean ignoreDaylightSavingTime) {
            this.ignoreDaylightSavingTime = ignoreDaylightSavingTime;
            this.ignoreDaylightSavingTime = ignoreDaylightSavingTime;
            this.firePropertyChange(PROP_IGNORE_DAYLIGHT_SAVING_TIME, this.ignoreDaylightSavingTime, this.ignoreDaylightSavingTime);
        }

        public boolean isIgnoreDaylightSavingTime() {
            return this.ignoreDaylightSavingTime;
        }
    }
}

