/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.apci;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckBuffer {
    private static final Logger logger = LoggerFactory.getLogger(AckBuffer.class);
    private int sendIndex;
    private int ackIndex;
    private final int maxSequence;
    private int sequence = 0;
    private int ackSequence = 0;
    private final Entry[] buffer;

    public AckBuffer(int size, int maxSequence) {
        this.buffer = new Entry[size];
        int i = 0;
        while (i < size) {
            this.buffer[i] = new Entry();
            this.buffer[i].ack = -1;
            ++i;
        }
        this.maxSequence = maxSequence;
    }

    public int addMessage(Object message) {
        if (this.isFull()) {
            throw new IndexOutOfBoundsException("Buffer is full");
        }
        int seq = this.sequence;
        int ack = this.sequence = (this.sequence + 1) % this.maxSequence;
        if (this.sequence == 0) {
            logger.info("Sequence resetted");
        }
        Entry entry = this.buffer[this.sendIndex];
        entry.message = message;
        entry.timestamp = System.currentTimeMillis();
        entry.ack = ack;
        this.sendIndex = (this.sendIndex + 1) % this.buffer.length;
        logger.trace("Add - Buffer - sendIndex: {}, ackIndex: {}", (Object)this.sendIndex, (Object)this.ackIndex);
        return seq;
    }

    public boolean isFull() {
        return this.buffer[this.sendIndex].ack >= 0;
    }

    /*
     * Unable to fully structure code
     */
    public void gotAck(int sequenceNumber) {
        AckBuffer.logger.trace("Ack - {}", (Object)sequenceNumber);
        if (sequenceNumber % this.maxSequence != this.ackSequence) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.buffer[this.ackIndex].clear();
            this.ackIndex = (this.ackIndex + 1) % this.buffer.length;
            AckBuffer.logger.trace("Ack - Buffer - sendIndex: {}, ackIndex: {}", (Object)this.sendIndex, (Object)this.ackIndex);
lbl7:
            // 2 sources

            ** while (this.buffer[this.ackIndex].ack >= 0 && this.buffer[this.ackIndex].ack != sequenceNumber)
        }
lbl8:
        // 1 sources

        if (this.buffer[this.ackIndex].ack != sequenceNumber) {
            throw new IllegalStateException(String.format("Received invalid ack message ack number: %s, lastMessage: %s", new Object[]{sequenceNumber, this.buffer[this.ackIndex].ack}));
        }
        this.buffer[this.ackIndex].clear();
        this.ackIndex = (this.ackIndex + 1) % this.buffer.length;
        this.ackSequence = sequenceNumber % this.maxSequence;
    }

    public int getOutstandingAcks() {
        if (this.ackSequence <= this.sequence) {
            return this.sequence - this.ackSequence;
        }
        return this.maxSequence - this.ackSequence + this.sequence;
    }

    private static class Entry {
        Object message;
        long timestamp;
        int ack;

        private Entry() {
        }

        public void clear() {
            this.message = null;
            this.ack = -1;
        }
    }
}

