/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.apci;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.apci.AckBuffer;
import org.eclipse.neoscada.protocol.iec60870.apci.InformationTransfer;
import org.eclipse.neoscada.protocol.iec60870.apci.MessageSource;
import org.eclipse.neoscada.protocol.iec60870.apci.Supervisory;
import org.eclipse.neoscada.protocol.iec60870.apci.Timer;
import org.eclipse.neoscada.protocol.iec60870.apci.TimerHandler;
import org.eclipse.neoscada.protocol.iec60870.apci.UnnumberedControl;
import org.eclipse.neoscada.protocol.iec60870.asdu.MessageManager;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DataTransmissionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannel
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessageChannel.class);
    private ChannelHandlerContext ctx;
    private final ProtocolOptions options;
    private Timer timer1;
    private Timer timer2;
    private Timer timer3;
    private final AckBuffer ackBuffer;
    private int receiveCounter;
    private int ackSentCounter = -1;
    private final Queue<WriteEvent> messageBuffer = new LinkedList<WriteEvent>();
    private final MessageManager manager;
    private final List<MessageSource> sources = new LinkedList<MessageSource>();
    private Runnable startTimers;

    public MessageChannel(ProtocolOptions options, MessageManager manager) {
        this.options = options != null ? options : new ProtocolOptions.Builder().build();
        this.ackBuffer = new AckBuffer(options.getMaxUnacknowledged(), options.getMaxSequenceNumber());
        this.manager = manager;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.timer1 = new Timer(ctx, "T1", new TimerHandler(){

            @Override
            public void handleTimeout() {
                MessageChannel.this.handleTimeout1();
            }
        });
        this.timer2 = new Timer(ctx, "T2", new TimerHandler(){

            @Override
            public void handleTimeout() {
                MessageChannel.this.handleTimeout2();
            }
        });
        this.timer3 = new Timer(ctx, "T3", new TimerHandler(){

            @Override
            public void handleTimeout() {
                MessageChannel.this.handleTimeout3();
            }
        });
        this.startTimers = new Runnable(){

            @Override
            public void run() {
                MessageChannel.this.timer1.start(MessageChannel.this.options.getTimeout1());
                MessageChannel.this.timer3.start(MessageChannel.this.options.getTimeout3());
            }
        };
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.info("Channel inactive");
        super.channelInactive(ctx);
        this.timer1.dispose();
        this.timer2.dispose();
        this.timer3.dispose();
    }

    protected void handleTimeout1() {
        logger.warn("Closing connection due to timeout: {}", (Object)this.ctx);
        this.ctx.close();
    }

    protected void handleTimeout2() {
        this.sendSupervisory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSupervisory() {
        MessageChannel messageChannel = this;
        synchronized (messageChannel) {
            if (this.ackSentCounter != this.receiveCounter) {
                this.ackSentCounter = this.receiveCounter;
                this.ctx.write((Object)new Supervisory(this.receiveCounter));
            }
        }
        this.ctx.flush();
    }

    protected void handleTimeout3() {
        this.sendTestAct();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.trace("channelRead - message: {}, ctx: {}", msg, (Object)ctx);
        this.timer3.restart(this.options.getTimeout3());
        if (msg instanceof InformationTransfer) {
            this.handleAck(ctx, ((InformationTransfer)msg).getReceiveSequenceNumber());
            this.handleInformationTransfer((InformationTransfer)msg);
        } else if (msg instanceof UnnumberedControl) {
            this.handleFunction(((UnnumberedControl)msg).getFunction());
        } else if (msg instanceof Supervisory) {
            this.handleAck(ctx, ((Supervisory)msg).getReceiveSequenceNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInformationTransfer(InformationTransfer msg) {
        MessageChannel messageChannel = this;
        synchronized (messageChannel) {
            int nr = msg.getSendSequenceNumber();
            if (nr != this.receiveCounter) {
                throw new RuntimeException(String.format("Sequence error - expected: %s, received: %s", this.receiveCounter, nr));
            }
            this.incrementReceiveCounter();
            if (this.receiveCounter - this.ackSentCounter >= this.options.getAcknowledgeWindow()) {
                this.timer2.stop();
                this.sendSupervisory();
            } else {
                this.timer2.start(this.options.getTimeout2());
            }
        }
        this.processInformationTransfer(this.ctx, msg);
    }

    private void processInformationTransfer(ChannelHandlerContext ctx, Object msg) {
        LinkedList<Object> out = new LinkedList<Object>();
        logger.trace("Passing to manager: {}", msg);
        ByteBuf errorData = this.manager.receiveMessage((InformationTransfer)msg, out);
        if (errorData != null) {
            logger.debug("Write error reply");
            this.writeMessageToChannel(ctx, errorData, null);
            ctx.flush();
        }
        for (Object e : out) {
            logger.trace("Passing message: {}", e);
            ctx.fireChannelRead(e);
        }
    }

    private void incrementReceiveCounter() {
        ++this.receiveCounter;
        if (this.receiveCounter > this.options.getMaxSequenceNumber()) {
            logger.info("Reset receive counter");
            this.receiveCounter = 0;
        }
    }

    protected synchronized void handleAck(ChannelHandlerContext ctx, int receiveSequenceNumber) {
        logger.trace("Received ACK up to: {}", (Object)receiveSequenceNumber);
        this.ackBuffer.gotAck(receiveSequenceNumber);
        this.sendFromBuffer();
        this.sendFromSources();
        ctx.flush();
    }

    private void sendFromBuffer() {
        while (!this.ackBuffer.isFull() && !this.messageBuffer.isEmpty()) {
            WriteEvent event = this.messageBuffer.poll();
            this.writeMessageToChannel(event.ctx, event.msg, event.promise);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Sending message from buffer: {} remaining", (Object)this.messageBuffer.size());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("AckBuffer(full) : {}, messageBuffer(empty): {}", (Object)this.ackBuffer.isFull(), (Object)this.messageBuffer.isEmpty());
        }
    }

    private void sendFromSources() {
        if (this.ackBuffer.isFull()) {
            return;
        }
        Iterator<MessageSource> i = this.sources.iterator();
        block0: while (i.hasNext() && !this.ackBuffer.isFull()) {
            MessageSource source = i.next();
            logger.trace("Try source: {}", (Object)source);
            while (!this.ackBuffer.isFull()) {
                Object msg = source.poll();
                logger.trace("Polled message: {}", msg);
                if (msg == null) continue block0;
                this.writeMessageToChannel(this.ctx, this.encode(this.ctx, msg), null);
            }
        }
    }

    private void sendTestAct() {
        logger.info("Request TESTFR: {}", (Object)this.ctx);
        this.timer1.start(this.options.getTimeout1());
        this.ctx.writeAndFlush((Object)new UnnumberedControl(UnnumberedControl.Function.TESTFR_ACT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        block12: {
            logger.trace("Write {}", msg);
            MessageChannel messageChannel = this;
            synchronized (messageChannel) {
                block11: {
                    if (!(msg instanceof DataTransmissionMessage)) break block11;
                    switch ((DataTransmissionMessage)((Object)msg)) {
                        case REQUEST_START: {
                            ctx.write((Object)new UnnumberedControl(UnnumberedControl.Function.STARTDT_ACT), promise);
                            break block12;
                        }
                        case CONFIRM_START: {
                            ctx.write((Object)new UnnumberedControl(UnnumberedControl.Function.STARTDT_CONFIRM), promise);
                            break block12;
                        }
                        case REQUEST_STOP: {
                            ctx.write((Object)new UnnumberedControl(UnnumberedControl.Function.STOPDT_ACT), promise);
                            break block12;
                        }
                        case CONFIRM_STOP: {
                            ctx.write((Object)new UnnumberedControl(UnnumberedControl.Function.STOPDT_CONFIRM), promise);
                            break block12;
                        }
                        default: {
                            throw new EncoderException(String.format("Unknown data transmission message: %s", msg));
                        }
                    }
                }
                if (msg == MessageSource.NOTIFY_TOKEN) {
                    this.handleMessageSourceUpdates(ctx);
                } else {
                    this.handleMessageWrite(ctx, msg, promise);
                }
            }
        }
    }

    private synchronized void handleMessageSourceUpdates(ChannelHandlerContext ctx) {
        if (this.ackBuffer.isFull()) {
            logger.trace("Received notify token but buffer is full");
            return;
        }
        this.sendFromSources();
        ctx.flush();
    }

    private void handleMessageWrite(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ByteBuf data = this.encode(ctx, msg);
        if (data == null) {
            return;
        }
        if (this.ackBuffer.isFull()) {
            logger.trace("Store message for later transmission");
            this.messageBuffer.add(new WriteEvent(ctx, data, promise));
        } else {
            this.writeMessageToChannel(ctx, data, promise);
        }
    }

    private ByteBuf encode(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = ctx.alloc().buffer(255);
        try {
            this.manager.encodeMessage(msg, buf);
            if (buf.isReadable()) {
                ByteBuf buf2 = buf;
                buf = null;
                ByteBuf byteBuf = buf2;
                return byteBuf;
            }
        }
        finally {
            ReferenceCountUtil.release((Object)buf);
        }
        return null;
    }

    private void writeMessageToChannel(ChannelHandlerContext ctx, ByteBuf data, ChannelPromise promise) {
        int seq = this.ackBuffer.addMessage(data);
        if (promise == null) {
            ctx.write((Object)new InformationTransfer(seq, this.receiveCounter, data));
        } else {
            ctx.write((Object)new InformationTransfer(seq, this.receiveCounter, data), promise);
        }
        logger.trace("Enqueued message as {} : {}", (Object)seq, (Object)data);
        this.timer2.stop();
    }

    private void handleFunction(UnnumberedControl.Function function) {
        logger.debug("Handle U-format function: {}", (Object)function);
        this.timer1.stop();
        this.timer3.restart(this.options.getTimeout3());
        switch (function) {
            case STARTDT_ACT: {
                this.ctx.fireChannelRead((Object)DataTransmissionMessage.REQUEST_START);
                return;
            }
            case STOPDT_ACT: {
                this.ctx.fireChannelRead((Object)DataTransmissionMessage.REQUEST_STOP);
                return;
            }
            case STARTDT_CONFIRM: {
                this.ctx.fireChannelRead((Object)DataTransmissionMessage.CONFIRM_START);
                return;
            }
            case STOPDT_CONFIRM: {
                this.ctx.fireChannelRead((Object)DataTransmissionMessage.CONFIRM_STOP);
                return;
            }
            case TESTFR_ACT: {
                this.ctx.writeAndFlush((Object)new UnnumberedControl(UnnumberedControl.Function.TESTFR_CONFIRM));
                return;
            }
            case TESTFR_CONFIRM: {
                return;
            }
        }
        throw new DecoderException(String.format("Cannot handle function: %s" + (Object)((Object)function), new Object[0]));
    }

    public synchronized void addSource(MessageSource messageSource) {
        this.sources.add(messageSource);
    }

    public void startTimers() {
        if (this.startTimers != null) {
            this.startTimers.run();
        }
    }

    private static class WriteEvent {
        private final ByteBuf msg;
        private final ChannelPromise promise;
        private final ChannelHandlerContext ctx;

        WriteEvent(ChannelHandlerContext ctx, ByteBuf msg, ChannelPromise promise) {
            this.ctx = ctx;
            this.msg = msg;
            this.promise = promise;
        }
    }
}

