/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public abstract class AbstractMeasuredValueNormalized
extends AbstractMessage {
    protected final List<InformationEntry<Double>> entries;
    private final boolean withTimestamp;

    public AbstractMeasuredValueNormalized(ASDUHeader header, List<InformationEntry<Double>> entries, boolean withTimestamp) {
        super(header);
        this.entries = entries;
        this.withTimestamp = withTimestamp;
    }

    public List<InformationEntry<Double>> getEntries() {
        return this.entries;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.entries.size(), this.header, out);
        for (InformationEntry<Double> entry : this.entries) {
            entry.getAddress().encode(options, out);
            TypeHelper.encodeNormalizedValue(options, out, entry.getValue(), this.withTimestamp);
        }
    }

    protected static List<InformationEntry<Double>> parseEntries(ProtocolOptions options, byte length, ByteBuf data, boolean withTimestamp) {
        ArrayList<InformationEntry<Double>> values = new ArrayList<InformationEntry<Double>>(length);
        int i = 0;
        while (i < length) {
            InformationObjectAddress address = InformationObjectAddress.parse(options, data);
            Value<Double> value = TypeHelper.parseNormalizedValue(options, data, withTimestamp);
            values.add(new InformationEntry<Double>(address, value));
            ++i;
        }
        return values;
    }
}

