/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractInformationObjectMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;

public abstract class AbstractSetPointCommandScaledValue
extends AbstractInformationObjectMessage {
    private final byte type;
    private final boolean execute;
    private final CommandValue<Short> value;
    private final boolean withTimestamp;

    public AbstractSetPointCommandScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, CommandValue<Short> value, boolean withTimestamp, byte type, boolean execute) {
        super(header, informationObjectAddress);
        this.value = value;
        this.type = type;
        this.execute = execute;
        this.withTimestamp = withTimestamp;
    }

    public byte getType() {
        return this.type;
    }

    public CommandValue<Short> getValue() {
        return this.value;
    }

    public boolean isExecute() {
        return this.execute;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, null, this.header, out);
        this.informationObjectAddress.encode(options, out);
        out.writeShort((int)this.value.getValue().shortValue());
        int b = 0;
        b = (byte)(b | this.type & 0xFF);
        b = (byte)(b | (this.execute ? 0 : 256));
        out.writeByte(b);
        if (this.withTimestamp) {
            TypeHelper.encodeTimestamp(options, out, this.value.getTimestamp());
        }
    }
}

