/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractInformationObjectMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;

public abstract class AbstractSingleCommand
extends AbstractInformationObjectMessage {
    private final CommandValue<Boolean> value;
    private final boolean withTimestamp;
    private final byte type;
    private final boolean execute;

    public AbstractSingleCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, CommandValue<Boolean> value, boolean withTimestamp, byte type, boolean execute) {
        super(header, informationObjectAddress);
        this.value = value;
        this.withTimestamp = withTimestamp;
        this.type = type;
        this.execute = execute;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isState() {
        return this.value.getValue();
    }

    public boolean getState() {
        return this.value.getValue();
    }

    public CommandValue<Boolean> getValue() {
        return this.value;
    }

    public boolean isExecute() {
        return this.execute;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, null, this.header, out);
        byte b = 0;
        b = (byte)(b | (this.isState() ? 1 : 0));
        b = (byte)(b | this.type << 2 & 0xFC);
        b = (byte)(b | (this.execute ? 0 : 256));
        this.informationObjectAddress.encode(options, out);
        out.writeByte((int)b);
        if (this.withTimestamp) {
            TypeHelper.encodeTimestamp(options, out, this.value.getTimestamp());
        }
    }
}

