/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=9, name="M_ME_NA_1", informationStructure=InformationStructure.SEQUENCE)
public class MeasuredValueNormalizedSequence
extends AbstractMessage {
    private final InformationObjectAddress startAddress;
    private final List<Value<Double>> values;

    private MeasuredValueNormalizedSequence(ASDUHeader header, InformationObjectAddress startAddress, List<Value<Double>> values) {
        super(header);
        this.startAddress = startAddress;
        this.values = values;
    }

    public List<Value<Double>> getValues() {
        return this.values;
    }

    public InformationObjectAddress getStartAddress() {
        return this.startAddress;
    }

    public static MeasuredValueNormalizedSequence parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress startAddress = InformationObjectAddress.parse(options, data);
        ArrayList<Value<Double>> values = new ArrayList<Value<Double>>(length);
        int i = 0;
        while (i < length) {
            values.add(TypeHelper.parseNormalizedValue(options, data, false));
            ++i;
        }
        return new MeasuredValueNormalizedSequence(header, startAddress, values);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.values.size(), this.header, out);
        this.startAddress.encode(options, out);
        for (Value<Double> value : this.values) {
            TypeHelper.encodeNormalizedValue(options, out, value, false);
        }
    }

    public static MeasuredValueNormalizedSequence create(InformationObjectAddress startAddress, ASDUHeader header, Value<Double> value) {
        return MeasuredValueNormalizedSequence.createInternal(startAddress, header, Collections.singletonList(value));
    }

    public static MeasuredValueNormalizedSequence create(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Double>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return MeasuredValueNormalizedSequence.createInternal(startAddress, header, new ArrayList<Value<Double>>(values));
    }

    private static MeasuredValueNormalizedSequence createInternal(InformationObjectAddress startAddress, ASDUHeader header, List<Value<Double>> values) {
        return new MeasuredValueNormalizedSequence(header, startAddress, values);
    }
}

