/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMeasuredValueNormalized;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=9, name="M_ME_NA_1", informationStructure=InformationStructure.SINGLE)
public class MeasuredValueNormalizedSingle
extends AbstractMeasuredValueNormalized {
    private MeasuredValueNormalizedSingle(ASDUHeader header, List<InformationEntry<Double>> entries) {
        super(header, entries, false);
    }

    public static MeasuredValueNormalizedSingle parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        return new MeasuredValueNormalizedSingle(header, MeasuredValueNormalizedSingle.parseEntries(options, length, data, false));
    }

    public static MeasuredValueNormalizedSingle create(ASDUHeader header, InformationObjectAddress address, Value<Double> value) {
        return MeasuredValueNormalizedSingle.createInternal(header, Collections.singletonList(new InformationEntry<Double>(address, value)));
    }

    public static MeasuredValueNormalizedSingle create(ASDUHeader header, List<InformationEntry<Double>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return MeasuredValueNormalizedSingle.createInternal(header, new ArrayList<InformationEntry<Double>>(values));
    }

    private static MeasuredValueNormalizedSingle createInternal(ASDUHeader header, List<InformationEntry<Double>> values) {
        return new MeasuredValueNormalizedSingle(header, values);
    }
}

