/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractSetPointCommandScaledValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.ValueCommandMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;

@ASDU(id=49, name="C_SE_NB_1", informationStructure=InformationStructure.SINGLE)
public class SetPointCommandScaledValue
extends AbstractSetPointCommandScaledValue
implements ValueCommandMessage {
    public SetPointCommandScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value, byte type, boolean execute) {
        super(header, informationObjectAddress, new CommandValue<Short>(value, System.currentTimeMillis()), false, type, execute);
    }

    public SetPointCommandScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value) {
        this(header, informationObjectAddress, value, 0, true);
    }

    @Override
    public SetPointCommandScaledValue mirror(Cause cause, boolean positive) {
        return new SetPointCommandScaledValue(this.header.clone(cause, positive), this.informationObjectAddress, this.getValue().getValue(), this.getType(), this.isExecute());
    }

    public static SetPointCommandScaledValue parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        short value = data.readShort();
        byte b = data.readByte();
        byte type = (byte)(b & 0xFF);
        boolean execute = (b & 0x100) <= 0;
        return new SetPointCommandScaledValue(header, address, value, type, execute);
    }
}

