/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractSetPointCommandScaledValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.ValueCommandMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;

@ASDU(id=62, name="C_SE_TB_1", informationStructure=InformationStructure.SINGLE)
public class SetPointCommandScaledValueTime
extends AbstractSetPointCommandScaledValue
implements ValueCommandMessage {
    public SetPointCommandScaledValueTime(ASDUHeader header, InformationObjectAddress informationObjectAddress, CommandValue<Short> value, byte type, boolean execute) {
        super(header, informationObjectAddress, value, true, type, execute);
    }

    public SetPointCommandScaledValueTime(ASDUHeader header, InformationObjectAddress informationObjectAddress, CommandValue<Short> value) {
        this(header, informationObjectAddress, value, 0, true);
    }

    @Override
    public SetPointCommandScaledValueTime mirror(Cause cause, boolean positive) {
        return new SetPointCommandScaledValueTime(this.header.clone(cause, positive), this.informationObjectAddress, this.getValue(), this.getType(), this.isExecute());
    }

    public static SetPointCommandScaledValueTime parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        short value = data.readShort();
        byte b = data.readByte();
        byte type = (byte)(b & 0xFF);
        boolean execute = (b & 0x100) <= 0;
        long timestamp = TypeHelper.parseTimestamp(options, data);
        return new SetPointCommandScaledValueTime(header, address, new CommandValue<Short>(value, timestamp), type, execute);
    }
}

